/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.ui.services.commands.AbstractUiHandler;

public class GenerateDocValidation
extends AbstractUiHandler {
    private final String rootCategoryId = "capella.category";
    private final String targetHtmlFileName = "ValidationRules.mediawiki";

    public Collection<String> getPluginsToProcess(IProject project) {
        VariableDescription desc;
        ArrayList<String> plugins = new ArrayList<String>();
        HashMap variables = ((Project)project).internalGetDescription().getVariables();
        if (variables != null && (desc = (VariableDescription)variables.get("projects")) != null) {
            plugins.addAll(Arrays.asList(desc.getValue().split(";")));
        }
        return plugins;
    }

    public List<String> getAllPluginsToProcess() {
        return Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()).stream().flatMap(x -> this.getPluginsToProcess((IProject)x).stream()).distinct().collect(Collectors.toList());
    }

    public Map<String, IProject> getProcessingDocumentationProjects() {
        HashMap<String, IProject> plugins = new HashMap<String, IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            for (String plugin : this.getPluginsToProcess(project)) {
                plugins.put(plugin, project);
            }
            ++n2;
        }
        return plugins;
    }

    public IFolder create(IFolder folder) {
        IProject project;
        IProject parent = project = folder.getProject();
        for (String segment : Arrays.asList(folder.getProjectRelativePath().segments())) {
            IFolder iFolder = parent = parent instanceof IProject ? parent.getFolder(segment) : ((IFolder)parent).getFolder(segment);
            if (parent.exists()) continue;
            try {
                ((IFolder)parent).create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return folder;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ConstraintRegistry reg = ConstraintRegistry.getInstance();
        List<String> pluginsToProcess = this.getAllPluginsToProcess();
        List allRegisteredRules = reg.getAllDescriptors().stream().filter(x -> ((Category)x.getCategories().iterator().next()).getPath().startsWith("capella.category")).collect(Collectors.toList());
        List pluginsWithRules = allRegisteredRules.stream().map(x -> x.getPluginId()).distinct().collect(Collectors.toList());
        if (pluginsToProcess.isEmpty()) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Import documentation", (String)NLS.bind((String)"There is no documentation plugin covering one of these plugins: {0}\n\nPlease import a validation documentation plugin into the workspace.\n\nTo make it generate towards a documentation plugin, please inspire from <.project> file of capella.validation.doc to make it target of one of validation rule plugin", (Object)pluginsWithRules.stream().collect(Collectors.joining("\n"))));
            return false;
        }
        Map<String, IProject> processingProjects = this.getProcessingDocumentationProjects();
        ArrayList unmatchedPlugins = new ArrayList(pluginsWithRules);
        unmatchedPlugins.removeAll(pluginsToProcess);
        MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Generation", (String)NLS.bind((String)"Documentation will be generated for : \n\n{0}\n\nDocumentation will not be generated for:\n\n{1}", (Object)pluginsToProcess.stream().collect(Collectors.joining("\n")), (Object)unmatchedPlugins.stream().collect(Collectors.joining("\n"))));
        List allRegisteredCategories = allRegisteredRules.stream().map(x -> ((Category)x.getCategories().iterator().next()).getPath()).distinct().collect(Collectors.toList());
        Collections.sort(allRegisteredCategories);
        for (String category : allRegisteredCategories) {
            List coveredRulesByCategory = allRegisteredRules.stream().filter(x -> ((Category)x.getCategories().iterator().next()).getPath().equals(category)).collect(Collectors.toList());
            coveredRulesByCategory.sort(new Comparator<IConstraintDescriptor>(){

                @Override
                public int compare(IConstraintDescriptor o1, IConstraintDescriptor o2) {
                    String id1 = o1.getId().substring(o1.getId().lastIndexOf(".") + 1);
                    String id2 = o2.getId().substring(o2.getId().lastIndexOf(".") + 1);
                    return id1.compareTo(id2);
                }
            });
            for (IProject project : coveredRulesByCategory.stream().map(r -> (IProject)processingProjects.get(r.getPluginId())).distinct().collect(Collectors.toList())) {
                if (project == null) continue;
                List coveredRulesByProject = coveredRulesByCategory.stream().filter(r -> processingProjects.get(r.getPluginId()) == project).collect(Collectors.toList());
                String folder = category.replace("capella.category", "html/Validation Rules");
                IFolder outputFolder = this.create(project.getFolder(folder));
                IFile outputFile = project.getFile(String.valueOf(folder) + "/" + "ValidationRules.mediawiki");
                String result = "";
                result = String.valueOf(result) + "      \n";
                result = String.valueOf(result) + "= " + WordUtils.capitalizeFully((String)category.replace("capella.category/", "").replaceAll("/", " > ").replaceAll("_", " ")) + " =\n";
                IFile images = project.getFile("html/Images");
                IPath path = images.getFullPath().makeRelativeTo(outputFolder.getFullPath());
                System.out.println(path);
                for (IConstraintDescriptor rule : coveredRulesByProject) {
                    String severity = rule.getSeverity().getLiteral();
                    result = String.valueOf(result) + "<br>\n";
                    result = String.valueOf(result) + "{| class=\"VALIDATION-RULE\"\n";
                    result = String.valueOf(result) + "!|[[Image:" + path + "/" + severity.toLowerCase() + ".gif|" + severity + "]]\n";
                    result = String.valueOf(result) + "|" + rule.getName() + " \n";
                    result = String.valueOf(result) + "|-\n";
                    result = String.valueOf(result) + "| colspan=\"2\"|" + rule.getDescription() + "\n";
                    result = String.valueOf(result) + "|}\n";
                }
                System.out.println(result);
                try {
                    if (outputFile.exists()) {
                        outputFile.setContents((InputStream)new ByteArrayInputStream(result.getBytes()), 0, (IProgressMonitor)new NullProgressMonitor());
                        continue;
                    }
                    outputFile.create((InputStream)new ByteArrayInputStream(result.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            for (IConstraintDescriptor rule : coveredRulesByCategory) {
                System.out.println(rule);
                System.out.println(processingProjects.get(rule.getPluginId()));
            }
        }
        MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Generation", (String)"Documentation mediawiki has been generated. Don't forget to generate html from mediawiki");
        return null;
    }
}

