/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.platform.sirius.ted.DataNotifier;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.handler.validation.CapellaDiagnostician;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRulePartialTestCase;

public class Rule_I_47_IncorrectImagePath
extends ValidationRulePartialTestCase {
    public static final String INVALID_LC2_PART = "44394260-1494-487b-94f1-659ace72ab84";

    @Override
    protected List<String> getScopeDefinition() {
        return Arrays.asList(INVALID_LC2_PART);
    }

    @Override
    protected EClass getTargetedEClass() {
        return ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT;
    }

    @Override
    protected String getRuleID() {
        return "org.polarsys.capella.core.platform.sirius.sirius.validation.I_47";
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        return Arrays.asList(new OracleDefinition(INVALID_LC2_PART, 1));
    }

    @Override
    public void test() throws Exception {
        Part partToCheck = this.prepareI47();
        CapellaDiagnostician capellaDiagnostician = new CapellaDiagnostician(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory(), (IProgressMonitor)new NullProgressMonitor());
        Diagnostic validate = capellaDiagnostician.validate((EObject)partToCheck);
        int severity = validate.getSeverity();
        Rule_I_47_IncorrectImagePath.assertEquals((String)"Bad diagnostic severity", (int)4, (int)severity);
        List children = validate.getChildren();
        Rule_I_47_IncorrectImagePath.assertEquals((String)"Bad diagnostic children number", (int)1, (int)children.size());
        Rule_I_47_IncorrectImagePath.assertEquals((String)"Bad diagnostic severity", (int)4, (int)((Diagnostic)children.get(0)).getSeverity());
        Rule_I_47_IncorrectImagePath.assertTrue((String)"Bad diagnotic message", (boolean)((Diagnostic)children.get(0)).getMessage().contains("(Image) The absolute path"));
    }

    private Part prepareI47() {
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        final Part part = (Part)IdManager.getInstance().getEObject(INVALID_LC2_PART, (IScope)scope);
        part.eResource().eAdapters().removeIf(DataNotifier.class::isInstance);
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)model.getEditingDomain());
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                part.setDescription("<p><img src=\"file:/C:/INVALID/PATH/11_Images/circle_ws2.png\" /></p>");
            }
        });
        return part;
    }

    @Override
    protected String getRequiredTestModel() {
        return "exchange-item-instance-and-part-model";
    }
}

