/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.misc;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.test.validation.rules.ju.testcases.AbstractSimpleValidationTest;

public class ComponentPortOrientationConsistencyTest
extends AbstractSimpleValidationTest {
    private static final String exchangeName = "exchange";
    private static final String sourceName = "target";
    private static final String targetName = "exchange";

    @Override
    protected List<String> getRuleIDs() {
        return Arrays.asList("org.polarsys.capella.core.data.fa.validation.I_20");
    }

    public void componentExchangePortOrientation_OUT_IN() {
        this.ok((EObject)this.testImpl(OrientationPortKind.OUT, OrientationPortKind.IN));
    }

    public void componentExchangePortOrientation_OUT_UNSET() {
        this.ok((EObject)this.testImpl(OrientationPortKind.OUT, OrientationPortKind.UNSET));
    }

    public void componentExchangePortOrientation_OUT_INOUT() {
        this.ok((EObject)this.testImpl(OrientationPortKind.OUT, OrientationPortKind.INOUT));
    }

    public void componentExchangePortOrientation_OUT_NULL() {
        this.ok((EObject)this.testImpl(OrientationPortKind.OUT, null));
    }

    public void componentExchangePortOrientation_INOUT_IN() {
        this.ok((EObject)this.testImpl(OrientationPortKind.INOUT, OrientationPortKind.IN));
    }

    public void componentExchangePortOrientation_INOUT_UNSET() {
        this.ok((EObject)this.testImpl(OrientationPortKind.INOUT, OrientationPortKind.UNSET));
    }

    public void componentExchangePortOrientation_INOUT_INOUT() {
        this.ok((EObject)this.testImpl(OrientationPortKind.INOUT, OrientationPortKind.INOUT));
    }

    public void componentExchangePortOrientation_INOUT_NULL() {
        this.ok((EObject)this.testImpl(OrientationPortKind.INOUT, null));
    }

    public void componentExchangePortOrientation_UNSET_IN() {
        this.ok((EObject)this.testImpl(OrientationPortKind.UNSET, OrientationPortKind.IN));
    }

    public void componentExchangePortOrientation_UNSET_INOUT() {
        this.ok((EObject)this.testImpl(OrientationPortKind.UNSET, OrientationPortKind.INOUT));
    }

    public void componentExchangePortOrientation_UNSET_UNSET() {
        this.ok((EObject)this.testImpl(OrientationPortKind.UNSET, OrientationPortKind.UNSET));
    }

    public void componentExchangePortOrientation_UNSET_NULL() {
        this.ok((EObject)this.testImpl(OrientationPortKind.UNSET, null));
    }

    public void componentExchangePortOrientation_NULL_IN() {
        this.ok((EObject)this.testImpl(null, OrientationPortKind.IN));
    }

    public void componentExchangePortOrientation_NULL_INOUT() {
        this.ok((EObject)this.testImpl(null, OrientationPortKind.INOUT));
    }

    public void componentExchangePortOrientation_NULL_UNSET() {
        this.ok((EObject)this.testImpl(null, OrientationPortKind.UNSET));
    }

    public void componentExchangePortOrientation_NULL_NULL() {
        this.ok((EObject)this.testImpl(null, OrientationPortKind.UNSET));
    }

    public void componentExchangePortOrientation_IN_IN() {
        this.ko((EObject)this.testImpl(OrientationPortKind.IN, OrientationPortKind.IN));
    }

    public void componentExchangePortOrientation_IN_INOUT() {
        this.ko((EObject)this.testImpl(OrientationPortKind.IN, OrientationPortKind.INOUT));
    }

    public void componentExchangePortOrientation_IN_UNSET() {
        this.ko((EObject)this.testImpl(OrientationPortKind.IN, OrientationPortKind.UNSET));
    }

    public void componentExchangePortOrientation_IN_NULL() {
        this.ko((EObject)this.testImpl(OrientationPortKind.IN, null));
    }

    public void componentExchangePortOrientation_IN_OUT() {
        this.ko((EObject)this.testImpl(OrientationPortKind.IN, OrientationPortKind.OUT));
    }

    public void componentExchangePortOrientation_INOUT_OUT() {
        this.ko((EObject)this.testImpl(OrientationPortKind.INOUT, OrientationPortKind.OUT));
    }

    public void componentExchangePortOrientation_UNSET_OUT() {
        this.ko((EObject)this.testImpl(OrientationPortKind.UNSET, OrientationPortKind.OUT));
    }

    public void componentExchangePortOrientation_NULL_OUT() {
        this.ko((EObject)this.testImpl(null, OrientationPortKind.OUT));
    }

    private ComponentExchange testImpl(OrientationPortKind sourceOrientation, OrientationPortKind targetOrientation) {
        ComponentExchange exchange = FaFactory.eINSTANCE.createComponentExchange("exchange");
        ComponentPort source = FaFactory.eINSTANCE.createComponentPort(sourceName);
        source.setOrientation(sourceOrientation);
        ComponentPort target = FaFactory.eINSTANCE.createComponentPort("exchange");
        target.setOrientation(targetOrientation);
        exchange.setSource((InformationsExchanger)source);
        exchange.setTarget((InformationsExchanger)target);
        return exchange;
    }

    @Override
    public void test() throws Exception {
        this.componentExchangePortOrientation_IN_IN();
        this.componentExchangePortOrientation_IN_INOUT();
        this.componentExchangePortOrientation_IN_NULL();
        this.componentExchangePortOrientation_IN_OUT();
        this.componentExchangePortOrientation_IN_UNSET();
        this.componentExchangePortOrientation_INOUT_IN();
        this.componentExchangePortOrientation_INOUT_INOUT();
        this.componentExchangePortOrientation_INOUT_NULL();
        this.componentExchangePortOrientation_INOUT_OUT();
        this.componentExchangePortOrientation_INOUT_UNSET();
        this.componentExchangePortOrientation_NULL_IN();
        this.componentExchangePortOrientation_NULL_INOUT();
        this.componentExchangePortOrientation_NULL_NULL();
        this.componentExchangePortOrientation_NULL_OUT();
        this.componentExchangePortOrientation_NULL_UNSET();
        this.componentExchangePortOrientation_OUT_IN();
        this.componentExchangePortOrientation_OUT_INOUT();
        this.componentExchangePortOrientation_OUT_NULL();
        this.componentExchangePortOrientation_OUT_UNSET();
        this.componentExchangePortOrientation_UNSET_IN();
        this.componentExchangePortOrientation_UNSET_INOUT();
        this.componentExchangePortOrientation_UNSET_NULL();
        this.componentExchangePortOrientation_UNSET_OUT();
        this.componentExchangePortOrientation_UNSET_UNSET();
    }
}

