/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project.operations;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.PartInitException;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.Messages;
import org.polarsys.capella.core.platform.sirius.ui.session.CapellaSessionHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.kitalpha.ad.integration.sirius.SiriusViewpointManager;

public class SessionCreationHelper {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("Model Management");

    public static URI buildAirdFileName(IProject eclipseProject, String projectName) {
        IPath path = eclipseProject.getFullPath();
        String airdFilename = String.valueOf(projectName) + '.' + "aird";
        path = path.append(airdFilename);
        URI airdResourceURI = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
        return airdResourceURI;
    }

    protected Session createAirdResource(IProject eclipseProject, IFile semanticResource, String projectName, IProgressMonitor monitor) {
        URI airdResourceURI = SessionCreationHelper.buildAirdFileName(eclipseProject, projectName);
        ArrayList<IFile> semanticFiles = new ArrayList<IFile>();
        semanticFiles.add(semanticResource);
        return this.createAirdSession(semanticFiles, airdResourceURI, monitor);
    }

    public Session createAirdSession(List<IFile> semanticFiles, URI airdResourceURI, IProgressMonitor monitor) {
        Session session = null;
        try {
            session = CapellaSessionHelper.createLocalSession(semanticFiles, (URI)airdResourceURI, (IProgressMonitor)monitor);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (PartInitException partInitException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return session;
    }

    public IProject createNewEclipseProject(String projectName, IPath location, Collection<IProject> referencedProjects, IProgressMonitor monitor) {
        IProject project = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot workspaceRoot = workspace.getRoot();
                project = workspaceRoot.getProject(projectName);
                if (!project.exists()) {
                    IProjectDescription description = this.createProjectDescription(project, location, referencedProjects);
                    project.create(description, (IProgressMonitor)progress.newChild(1));
                }
                project.open((IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException coreException) {
                progress.done();
            }
        }
        finally {
            progress.done();
        }
        return project;
    }

    protected IProjectDescription createProjectDescription(IProject project, IPath projectPath, Collection<IProject> referencedProjects) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String name = project.getName();
        IProjectDescription description = workspace.newProjectDescription(name);
        if (projectPath != null) {
            description.setLocation(projectPath.append(name));
        }
        this.setNatureProject(project, description);
        description = this.addReferencedProjects(project, description, referencedProjects);
        return description;
    }

    protected void setNatureProject(IProject project, IProjectDescription description) {
        if (!description.hasNature("org.polarsys.capella.project.nature")) {
            String[] newNatures = new String[]{"org.polarsys.capella.project.nature"};
            description.setNatureIds(newNatures);
        }
    }

    protected IProjectDescription addReferencedProjects(IProject project, IProjectDescription description, Collection<IProject> referencedProjects) {
        IProject[] references = description.getReferencedProjects();
        int i = 0;
        IProject[] returnReferencedProjects = new IProject[references.length + referencedProjects.size()];
        i = 0;
        while (i < references.length) {
            returnReferencedProjects[i] = references[i];
            ++i;
        }
        Iterator<IProject> projects = referencedProjects.iterator();
        while (projects.hasNext()) {
            returnReferencedProjects[i] = projects.next();
            ++i;
        }
        description.setReferencedProjects(returnReferencedProjects);
        return description;
    }

    protected IFile createSemanticResource(IProject eclipseProject, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        TransactionalEditingDomain domain = manager.getEditingDomain();
        ICommand command = null;
        try {
            IFile semanticFile;
            progress.beginTask("Create an empty resource", 1);
            Resource semanticResource = CapellaResourceHelper.createCapellaResource((IProject)eclipseProject, (String)eclipseProject.getName(), (TransactionalEditingDomain)domain);
            progress.worked(1);
            progress.beginTask("Create semantic root element", 1);
            command = this.createInitialElementsCommand(semanticResource, eclipseProject.getName(), monitor);
            if (command != null) {
                manager.execute(command);
            }
            progress.worked(1);
            progress.beginTask("Create initial skeletton", 1);
            command = this.updateInitialElementsCommand(semanticResource, eclipseProject.getName(), monitor);
            if (command != null) {
                manager.execute(command);
            }
            progress.worked(1);
            try {
                progress.beginTask("Save semantic model", 1);
                semanticResource.save(Collections.emptyMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
            progress.worked(1);
            IFile iFile = semanticFile = EcoreUtil2.getFile((Resource)semanticResource);
            return iFile;
        }
        finally {
            domain.dispose();
            progress.done();
            ExecutionManagerRegistry.getInstance().removeManager(manager);
        }
    }

    protected ICommand createInitialElementsCommand(Resource semanticResource, String name, IProgressMonitor monitor) {
        return null;
    }

    protected ICommand updateInitialElementsCommand(Resource semanticResource, String name, IProgressMonitor monitor) {
        return null;
    }

    public Session createFullProject(String projectName, IPath newPath, Collection<IProject> referencedProjects, Collection<Viewpoint> selectedViewpoints, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            int stepCount = 7;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(Messages.getString("NewProjectWizard.CreateProject_Title")) + projectName), (int)stepCount);
            IProject eclipseProject = null;
            eclipseProject = this.createNewEclipseProject(projectName, newPath, referencedProjects, (IProgressMonitor)progress.newChild(1));
            IFile semanticFile = this.createSemanticResource(eclipseProject, (IProgressMonitor)progress.newChild(1));
            Session session = this.createAirdResource(eclipseProject, semanticFile, projectName, (IProgressMonitor)progress.newChild(1));
            if (session == null) {
                throw new InterruptedException("Cannot create the session");
            }
            boolean backup = this.disableActivityExplorerOnOpenSession();
            session.open((IProgressMonitor)progress.newChild(1));
            ILibraryManager.INSTANCE.getModel(session.getTransactionalEditingDomain());
            SiriusViewpointManager.INSTANCE.filter(session, selectedViewpoints);
            SessionHelper.activateViewpoints((Session)session, selectedViewpoints);
            progress.worked(1);
            this.restoreActivityExplorerOnOpenSession(backup);
            try {
                if (SessionStatus.DIRTY.equals((Object)session.getStatus())) {
                    session.save((IProgressMonitor)progress.newChild(1));
                }
            }
            catch (Exception ex) {
                __logger.debug((Object)new EmbeddedMessage(ex.getMessage(), "Model Management"));
            }
            IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(session);
            editingSession.open();
            Session session2 = session;
            return session2;
        }
        finally {
            monitor.done();
        }
    }

    protected boolean disableActivityExplorerOnOpenSession() {
        boolean backup = ActivityExplorerActivator.getDefault().getPreferenceStore().getBoolean("openactivityexplorer");
        ActivityExplorerActivator.getDefault().getPreferenceStore().setValue("openactivityexplorer", false);
        return backup;
    }

    protected void restoreActivityExplorerOnOpenSession(boolean backup) {
        ActivityExplorerActivator.getDefault().getPreferenceStore().setValue("openactivityexplorer", backup);
    }
}

