/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class GitProjectPropertyPage
extends PropertyPage {
    private Text gitDir;
    private Text branch;
    private Text state;
    private Text workDir;

    protected Control createContents(Composite parent) {
        Composite composite;
        block6: {
            Repository repository;
            this.noDefaultAndApplyButton();
            composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            this.gitDir = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelGitDir);
            this.workDir = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelWorkdir);
            this.branch = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelBranch);
            this.state = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelState);
            IProject project = null;
            IAdaptable element = this.getElement();
            if (element instanceof IResource) {
                project = ((IResource)element).getProject();
            } else {
                IResource adapter = CommonUtils.getAdapter(element, IResource.class);
                if (adapter instanceof IResource) {
                    project = adapter.getProject();
                }
            }
            RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)project);
            if (mapping != null && (repository = mapping.getRepository()) != null) {
                try {
                    this.createHeadLink(repository, composite);
                    this.fillValues(repository);
                }
                catch (IOException e) {
                    if (!GitTraceLocation.UI.isActive()) break block6;
                    GitTraceLocation.getTrace().trace(GitTraceLocation.UI.getLocation(), e.getMessage(), (Throwable)e);
                }
            }
        }
        return composite;
    }

    private void createHeadLink(final Repository repository, Composite composite) throws IOException {
        final ObjectId objectId = repository.resolve(repository.getFullBranch());
        if (objectId == null) {
            Text headLabel = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelId);
            if (repository.getAllRefs().size() == 0) {
                headLabel.setText(UIText.GitProjectPropertyPage_ValueEmptyRepository);
            } else {
                headLabel.setText(UIText.GitProjectPropertyPage_ValueUnbornBranch);
            }
        } else {
            Hyperlink headLink = this.createHeadHyperLink(composite, UIText.GitProjectPropertyPage_LabelId);
            headLink.setText(objectId.name());
            headLink.setUnderlined(true);
            headLink.setFont(JFaceResources.getDialogFont());
            headLink.setForeground(JFaceColors.getHyperlinkText((Display)headLink.getDisplay()));
            headLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    RepositoryCommit commit = GitProjectPropertyPage.this.getCommit(repository, objectId);
                    if (commit != null) {
                        CommitEditor.openQuiet(commit);
                    }
                }
            });
        }
    }

    private void fillValues(Repository repository) throws IOException {
        this.gitDir.setText(repository.getDirectory().getAbsolutePath());
        this.branch.setText(repository.getBranch());
        this.workDir.setText(repository.getWorkTree().getAbsolutePath());
        this.state.setText(repository.getRepositoryState().getDescription());
    }

    private RepositoryCommit getCommit(Repository repository, ObjectId objectId) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk walk = new RevWalk(repository);){
                RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
                RevCommit[] revCommitArray = commit.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit parent = revCommitArray[n2];
                    walk.parseBody((RevObject)parent);
                    ++n2;
                }
                return new RepositoryCommit(repository, commit);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.showError(NLS.bind((String)UIText.GitProjectPropertyPage_UnableToGetCommit, (Object)objectId.name()), e);
            return null;
        }
    }

    private Text createLabeledReadOnlyText(Composite parent, String labelText) {
        this.createLabel(parent, labelText);
        Text text = this.createText(parent);
        return text;
    }

    private Hyperlink createHeadHyperLink(Composite composite, String labelText) {
        this.createLabel(composite, labelText);
        Hyperlink hyperlink = new Hyperlink(composite, 0);
        hyperlink.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        return hyperlink;
    }

    private Text createText(Composite parent) {
        GridData data = new GridData();
        Text text = UIUtils.createSelectableLabel(parent, 16384);
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        text.setLayoutData((Object)data);
        return text;
    }

    private void createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
    }
}

