/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.internal.navigator.resources.actions.EditActionGroup;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaEditActionGroup
extends EditActionGroup {
    private Shell _shell;
    private DeleteResourceAction _deleteAction;

    public CapellaEditActionGroup(Shell shell_p) {
        super(shell_p);
        this._shell = shell_p;
        this.makeLocalActions();
    }

    public void fillActionBars(IActionBars actionBars_p) {
        super.fillActionBars(actionBars_p);
        IAction deleteActionHandler = actionBars_p.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this._deleteAction.setEnabled(deleteActionHandler.isEnabled());
        actionBars_p.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this._deleteAction);
    }

    public void fillContextMenu(IMenuManager menu_p) {
        super.fillContextMenu(menu_p);
        menu_p.remove(this._deleteAction.getId());
        menu_p.appendToGroup("group.edit", (IAction)this._deleteAction);
    }

    protected void makeLocalActions() {
        this._deleteAction = new DeleteResourceAction(this._shell){

            public void run() {
                List<IProject> hostingProjects;
                List selectedResources = this.getSelectedResources();
                IResource[] selectedResourcesArray = selectedResources.toArray(new IResource[selectedResources.size()]);
                boolean containsOnlyProjects = this.containsOnlyProjects(selectedResourcesArray);
                if (containsOnlyProjects) {
                    SessionHelper.closeUiSessions((List)selectedResources);
                }
                if ((hostingProjects = this.containsCapellaOrAirdResources(selectedResourcesArray)) != null) {
                    SessionHelper.closeUiSessions(hostingProjects);
                }
                super.run();
            }

            protected List<IProject> containsCapellaOrAirdResources(IResource[] selectedResourcesArray_p) {
                HashSet<IProject> hostingProjects = null;
                IResource[] iResourceArray = selectedResourcesArray_p;
                int n = selectedResourcesArray_p.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource currentResource = iResourceArray[n2];
                    String fileExtension = currentResource.getFileExtension();
                    if (1 == currentResource.getType() && (CapellaResourceHelper.isCapellaResource((IResource)currentResource) || "aird".equals(fileExtension) || "airdfragment".equals(fileExtension))) {
                        if (hostingProjects == null) {
                            hostingProjects = new HashSet<IProject>(1);
                        }
                        hostingProjects.add(currentResource.getProject());
                    }
                    ++n2;
                }
                return hostingProjects != null ? new ArrayList(hostingProjects) : null;
            }

            protected boolean containsOnlyProjects(IResource[] resources) {
                int types = this.getSelectedResourceTypes(resources);
                return types == 4;
            }

            protected int getSelectedResourceTypes(IResource[] resources) {
                int types = 0;
                int i = 0;
                while (i < resources.length) {
                    types |= resources[i].getType();
                    ++i;
                }
                return types;
            }
        };
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this._deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this._deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this._deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this._deleteAction.selectionChanged(selection);
    }
}

