/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;

public class LocateInCapellaExplorerAction
implements IObjectActionDelegate,
IViewActionDelegate {
    private Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private boolean _ignoreWorkbenchPartSite;
    private IWorkbenchPartSite _site;

    protected Object getFirstSelectedElement(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        return structuredSelection.getFirstElement();
    }

    protected ISelection getSelection() {
        return this._site != null ? this._site.getSelectionProvider().getSelection() : StructuredSelection.EMPTY;
    }

    public void init(IViewPart view) {
        this._site = view.getSite();
    }

    public void run(IAction action) {
        ISelection selection;
        if ((this._ignoreWorkbenchPartSite || this._site != null) && (selection = this.getSelection()) instanceof IStructuredSelection) {
            Object uiSelectedElement = this.getFirstSelectedElement(selection);
            Object elementToSelectInCapellaExplorer = null;
            if (uiSelectedElement instanceof ItemWrapper) {
                uiSelectedElement = ((ItemWrapper)uiSelectedElement).getWrappedObject();
            }
            if (CapellaResourceHelper.isSemanticElement((Object)(elementToSelectInCapellaExplorer = uiSelectedElement instanceof DRepresentationDescriptor ? uiSelectedElement : LocateInCapellaExplorerAction.getElement(uiSelectedElement))) || elementToSelectInCapellaExplorer instanceof DRepresentation || elementToSelectInCapellaExplorer instanceof DRepresentationDescriptor) {
                this.selectElementInCapellaExplorer((ISelection)new StructuredSelection(elementToSelectInCapellaExplorer));
            }
        }
    }

    protected void selectElementInCapellaExplorer(ISelection selection) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            CapellaCommonNavigator explorerView = (CapellaCommonNavigator)activePage.findView("capella.project.explorer");
            if (explorerView == null) {
                explorerView = (CapellaCommonNavigator)activePage.showView("capella.project.explorer");
            }
            explorerView.selectReveal(selection);
        }
        catch (PartInitException exception) {
            this.__logger.warn((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"), (Throwable)exception);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._site = targetPart.getSite();
    }

    public void setSite(IWorkbenchPartSite site) {
        this._site = site;
    }

    public void shouldIgnoreWorkbenchPartSite(boolean ignore) {
        this._ignoreWorkbenchPartSite = ignore;
    }

    public static Object getElement(Object uiSelectedElement) {
        boolean allowMultiplePart;
        Object result = null;
        if (uiSelectedElement == null) {
            return result;
        }
        if (CapellaResourceHelper.isSemanticElement((Object)uiSelectedElement)) {
            result = uiSelectedElement;
        } else if (uiSelectedElement instanceof GraphicalEditPart) {
            GraphicalEditPart editPart = (GraphicalEditPart)uiSelectedElement;
            result = editPart.getModel();
            if (result instanceof View) {
                View view = (View)result;
                result = view.getElement();
            }
            if (result instanceof DSemanticDecorator && !(result instanceof DSemanticDiagram)) {
                DSemanticDecorator semanticDecorator = (DSemanticDecorator)result;
                result = semanticDecorator.getTarget();
            }
            if (result instanceof DRepresentation) {
                result = RepresentationHelper.getRepresentationDescriptor((DRepresentation)((DRepresentation)result));
            }
        } else if (uiSelectedElement instanceof DSemanticDecorator && !(uiSelectedElement instanceof DSemanticDiagram)) {
            DSemanticDecorator semanticDecorator = (DSemanticDecorator)uiSelectedElement;
            result = semanticDecorator.getTarget();
        } else if (uiSelectedElement instanceof EObjectWrapper) {
            result = ((EObjectWrapper)uiSelectedElement).getElement();
        }
        if (result instanceof Part && !(allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((Part)result)))) && !(((Part)result).getAbstractType() instanceof ConfigurationItem)) {
            result = ((Part)result).getAbstractType();
        }
        return result;
    }
}

