/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;

public class SortContentAction
extends BaseSelectionListenerAction {
    public static final Comparator<EObject> abstractNamedElementNameComparator = new Comparator<EObject>(){

        @Override
        public int compare(EObject o1, EObject o2) {
            String o1Name = null;
            String o2Name = null;
            EAttribute attribute_o1 = CapellaResourceHelper.getEditableAttribute((EObject)o1);
            EAttribute attribute_o2 = CapellaResourceHelper.getEditableAttribute((EObject)o2);
            if (attribute_o1 != null) {
                o1Name = (String)o1.eGet((EStructuralFeature)attribute_o1);
            }
            if (attribute_o2 != null) {
                o2Name = (String)o2.eGet((EStructuralFeature)attribute_o2);
            }
            if (o1Name == null && o2Name == null) {
                return 0;
            }
            if (o1Name == null && o2Name != null) {
                return -1;
            }
            if (o1Name != null && o2Name == null) {
                return 1;
            }
            String o1NameInLowerCase = o1Name.toLowerCase().trim();
            String o2NameInLowerCase = o2Name.toLowerCase().trim();
            return o1NameInLowerCase.compareTo(o2NameInLowerCase);
        }
    };

    public SortContentAction() {
        super(Messages.SortContentAction_Label);
    }

    public SortContentAction(String sortLabel) {
        super(sortLabel);
    }

    public void run() {
        final List selectedElements = this.getStructuredSelection().toList();
        TransactionHelper.getExecutionManager(this.filterNonEObjects(selectedElements)).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                for (Object selectedElement : selectedElements) {
                    if (!(selectedElement instanceof EObject)) continue;
                    EObject selectedEObject = (EObject)selectedElement;
                    for (EReference ownedRef : selectedEObject.eClass().getEAllContainments()) {
                        if (!ownedRef.isMany()) continue;
                        EList ownedElements = (EList)selectedEObject.eGet((EStructuralFeature)ownedRef);
                        System.out.println(ownedElements);
                        if (ownedElements.size() < 2) continue;
                        ECollections.sort((EList)ownedElements, abstractNamedElementNameComparator);
                    }
                }
            }
        });
    }

    protected Collection<EObject> filterNonEObjects(Collection elements) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object elt : elements) {
            if (!(elt instanceof EObject)) continue;
            result.add((EObject)elt);
        }
        return result;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object selectedElement : selection.toList()) {
            if (CapellaResourceHelper.isSemanticElement(selectedElement)) continue;
            return false;
        }
        return true;
    }
}

