/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers.Messages;
import org.polarsys.capella.core.sirius.ui.actions.OpenRepresentationsAction;

public class OpenRepresentationActionProvider
extends CommonActionProvider {
    public void fillContextMenu(IMenuManager menu_p) {
        Collection selectedViewpoints;
        Collection descriptions;
        EObject firstSelectedEObject;
        Session currentSession;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof EObject && (currentSession = SessionManager.INSTANCE.getSession(firstSelectedEObject = (EObject)firstElement)) != null && !(descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints = currentSession.getSelectedViewpoints(false), firstSelectedEObject)).isEmpty()) {
            MenuManager openDiagramMenu = new MenuManager(Messages.OpenRepresentationActionProvider_OpenRepresentationAction_Title, "capella.project.diagrams.menu");
            for (RepresentationDescription description : descriptions) {
                if (DialectManager.INSTANCE.getRepresentations(description, currentSession) == null) continue;
                Collection rep = DialectManager.INSTANCE.getRepresentations(description, currentSession);
                Collection ownedRep = DialectManager.INSTANCE.getRepresentations(firstSelectedEObject, currentSession);
                rep.retainAll(ownedRep);
                for (DRepresentation drep : rep) {
                    OpenRepresentationsAction ora = new OpenRepresentationsAction(description, drep);
                    openDiagramMenu.add((IAction)ora);
                }
            }
            if (firstSelectedEObject instanceof AbstractCapability) {
                for (Viewpoint vp : selectedViewpoints) {
                    for (RepresentationDescription representationDescription : vp.getOwnedRepresentations()) {
                        SequenceDiagramDescription sdd;
                        if (!(representationDescription instanceof SequenceDiagramDescription) || DialectManager.INSTANCE.getRepresentations((RepresentationDescription)(sdd = (SequenceDiagramDescription)representationDescription), currentSession) == null) continue;
                        Collection rep = DialectManager.INSTANCE.getRepresentations((RepresentationDescription)sdd, currentSession);
                        ArrayList ownedRep = new ArrayList();
                        EList lstScenarios = ((AbstractCapability)firstSelectedEObject).getOwnedScenarios();
                        for (Scenario scenario : lstScenarios) {
                            Collection repScenario = DialectManager.INSTANCE.getRepresentations((EObject)scenario, currentSession);
                            ownedRep.addAll(repScenario);
                        }
                        rep.retainAll(ownedRep);
                        for (DRepresentation drep : rep) {
                            OpenRepresentationsAction ora = new OpenRepresentationsAction((RepresentationDescription)sdd, drep);
                            openDiagramMenu.add((IAction)ora);
                        }
                    }
                }
            }
            if (openDiagramMenu.getSize() > 0) {
                menu_p.appendToGroup("group.new", (IContributionItem)openDiagramMenu);
            }
        }
    }
}

