/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.handlers;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.NavigateAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.internal.navigate.NavigationAdvisor;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;

public class GotoRelatedElementsHandler
extends CompoundContributionItem {
    private static final IContributionItem[] NO_CONTRIBUTION_ITEM = new IContributionItem[0];

    protected IContributionItem[] getContributionItems() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart activePart = activePage.getActivePart();
        CapellaCommonNavigator capellaCommonNavigator = (CapellaCommonNavigator)activePage.findView("capella.project.explorer");
        if (activePart == null || capellaCommonNavigator == null) {
            return NO_CONTRIBUTION_ITEM;
        }
        ISelection selection = activePart.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            EObject element = this.getModelElement(((IStructuredSelection)selection).getFirstElement());
            if (element == null) {
                return NO_CONTRIBUTION_ITEM;
            }
            if (!CapellaResourceHelper.isSemanticElement((Object)element)) {
                return NO_CONTRIBUTION_ITEM;
            }
            ArrayList<ActionContributionItem> result = new ArrayList<ActionContributionItem>(0);
            Set<EObject> navigableElements = NavigationAdvisor.getInstance().getNavigableElements(element);
            for (EObject currentModelElement : navigableElements) {
                NavigateAction action = new NavigateAction(currentModelElement, (StructuredViewer)capellaCommonNavigator.getCommonViewer());
                action.setText(EObjectLabelProviderHelper.getText((EObject)currentModelElement));
                action.setImageDescriptor(ImageDescriptor.createFromImage((Image)EObjectLabelProviderHelper.getImage((EObject)currentModelElement)));
                result.add(new ActionContributionItem((IAction)action));
            }
            return result.toArray(new IContributionItem[result.size()]);
        }
        return NO_CONTRIBUTION_ITEM;
    }

    public void fill(Menu menu_p, int index_p) {
        super.fill(menu_p, index_p);
        menu_p.getParentItem().setImage(CapellaNavigatorPlugin.getDefault().getImage("capella_16.png"));
    }

    protected EObject getModelElement(Object uiSelectedElement_p) {
        Object semanticElement = LocateInCapellaExplorerAction.getElement(uiSelectedElement_p);
        return semanticElement instanceof EObject ? (EObject)semanticElement : null;
    }
}

