/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.helpers;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public abstract class AbstractFixDiagramHelper {
    private static final Logger LOGGER = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private String logPrefix;

    public Set<DRepresentation> fixDiagram(Session session) {
        HashSet<DRepresentation> res = new HashSet<DRepresentation>();
        for (Resource resource : session.getAllSessionResources()) {
            res.addAll(this.fixDiagram(resource));
        }
        return res;
    }

    public Set<DRepresentation> cleanDiagram(Session session) {
        HashSet<DRepresentation> res = new HashSet<DRepresentation>();
        for (Resource resource : session.getAllSessionResources()) {
            res.addAll(this.cleanDiagram(resource));
        }
        return res;
    }

    public Set<DRepresentation> fixDiagram(Resource resource) {
        long start = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
        Map<DRepresentation, Integer> diagramToModifyObjectCount = this.doFixDiagrams(resource);
        long stop = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
        this.logInfoView(resource, start, stop, diagramToModifyObjectCount);
        return diagramToModifyObjectCount.keySet();
    }

    public Set<DRepresentation> cleanDiagram(Resource resource) {
        long start = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
        Map<DRepresentation, Integer> diagramToModifyObjectCount = this.doCleanDiagrams(resource);
        long stop = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
        this.logInfoView(resource, start, stop, diagramToModifyObjectCount);
        return diagramToModifyObjectCount.keySet();
    }

    private void logInfoView(Resource resource, long start, long stop, Map<DRepresentation, Integer> diagramToModifyObjectCount) {
        if (!diagramToModifyObjectCount.keySet().isEmpty()) {
            this.logInfo("-----");
            int totalModifiedObjectCount = 0;
            for (DRepresentation diagram : diagramToModifyObjectCount.keySet()) {
                Integer count = diagramToModifyObjectCount.get(diagram);
                this.logInfo(count + " annotation(s) restored in " + diagram.getName());
                totalModifiedObjectCount += count.intValue();
            }
            this.logInfo("-----");
            this.logInfo("Total restored annotation(s) : " + totalModifiedObjectCount);
            this.logInfo("Total fixed diagrams : " + diagramToModifyObjectCount.keySet().size());
            this.logInfo("Diagrams fix took : " + (stop - start) / 1000000L + " ms");
        } else {
            this.logInfo("Nothing to fix in " + resource.getURI().lastSegment());
        }
        this.logInfo("End processing " + resource.getURI().lastSegment());
        this.logInfo("-----------------------------------------------------------");
    }

    protected abstract Map<DRepresentation, Integer> doFixDiagrams(Resource var1);

    protected Map<DRepresentation, Integer> doCleanDiagrams(Resource resource) {
        return null;
    }

    protected void logInfo(String message) {
        LOGGER.info((Object)(String.valueOf(this.logPrefix) + " : " + message));
    }

    protected void incrementCounter(Map<DRepresentation, Integer> diagramToModifyObjectCount, DRepresentation representation) {
        Integer count = diagramToModifyObjectCount.get(representation);
        if (count != null) {
            count = count + 1;
            diagramToModifyObjectCount.put(representation, count);
        } else {
            diagramToModifyObjectCount.put(representation, 1);
        }
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    public void setLogPrefix(String logPrefix) {
        this.logPrefix = logPrefix;
    }
}

