/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.helpers;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.helpers.AbstractFixDiagramHelper;

public class FixDAnnotationsHelper
extends AbstractFixDiagramHelper {
    protected static Map<String, String> dAnnotationMigrationMapping = ImmutableMap.of((Object)"http://www.thalesgroup.com/mde/melody/NotVisibleInDoc", (Object)"http://www.polarsys.org/capella/core/NotVisibleInDoc", (Object)"http://www.thalesgroup.com/mde/melody/NotVisibleInLM", (Object)"http://www.polarsys.org/capella/core/NotVisibleInLM", (Object)"http://www.thalesgroup.com/mde/melody/ProgressStatus", (Object)"http://www.polarsys.org/capella/core/ProgressStatus", (Object)"http://www.thalesgroup.com/mde/melody/StatusReview", (Object)"http://www.polarsys.org/capella/core/StatusReview");

    public FixDAnnotationsHelper() {
        this.setLogPrefix(Messages.FixDAnnotationsJobName);
    }

    public Set<DRepresentation> fixDiagramEventuallyClean(Session session, boolean onlyClean) {
        if (!onlyClean) {
            return this.fixDiagram(session);
        }
        return this.cleanDiagram(session);
    }

    @Override
    protected Map<DRepresentation, Integer> doFixDiagrams(Resource resource) {
        HashMap<DRepresentation, Integer> diagramToModifyObjectCount = new HashMap<DRepresentation, Integer>();
        DAnalysis dAnalysis = this.getFirstDAnalysis(resource);
        for (DView dView : dAnalysis.getOwnedViews()) {
            for (DRepresentationDescriptor representationDesc : dView.getOwnedRepresentationDescriptors()) {
                DRepresentation representation = representationDesc.getRepresentation();
                for (String oldAnnotationID : dAnnotationMigrationMapping.keySet()) {
                    DAnnotation oldAnnotation = RepresentationHelper.getAnnotation((String)oldAnnotationID, (DRepresentation)representation);
                    if (oldAnnotation == null) continue;
                    String newAnnotationID = dAnnotationMigrationMapping.get(oldAnnotationID);
                    DAnnotation newAnnotation = RepresentationHelper.getAnnotation((String)newAnnotationID, (DRepresentation)representation);
                    if (newAnnotation == null) {
                        oldAnnotation.setSource(newAnnotationID);
                    } else {
                        RepresentationHelper.removeAnnotation((String)oldAnnotationID, (DRepresentation)representation);
                    }
                    this.incrementCounter(diagramToModifyObjectCount, representation);
                }
            }
        }
        return diagramToModifyObjectCount;
    }

    @Override
    protected Map<DRepresentation, Integer> doCleanDiagrams(Resource resource) {
        HashMap<DRepresentation, Integer> diagramToModifyObjectCount = new HashMap<DRepresentation, Integer>();
        DAnalysis dAnalysis = this.getFirstDAnalysis(resource);
        for (DView dView : dAnalysis.getOwnedViews()) {
            for (DRepresentationDescriptor representationDesc : dView.getOwnedRepresentationDescriptors()) {
                DRepresentation representation = representationDesc.getRepresentation();
                for (String oldAnnotationID : dAnnotationMigrationMapping.keySet()) {
                    DAnnotation oldAnnotation = RepresentationHelper.getAnnotation((String)oldAnnotationID, (DRepresentation)representation);
                    if (oldAnnotation == null) continue;
                    RepresentationHelper.removeAnnotation((String)oldAnnotationID, (DRepresentation)representation);
                    this.incrementCounter(diagramToModifyObjectCount, representation);
                }
            }
        }
        return diagramToModifyObjectCount;
    }

    public DAnalysis getFirstDAnalysis(Resource resource) {
        if (!CapellaResourceHelper.isAirdResource((URI)resource.getURI())) {
            return null;
        }
        if (!resource.getAllContents().hasNext()) {
            return null;
        }
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!(next instanceof DAnalysis)) continue;
            return (DAnalysis)next;
        }
        return null;
    }
}

