/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.ItemDecorator;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.model.copypaste.SharedCutPasteClipboard;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.SessionLabelProviderHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaNavigatorLabelProvider
extends MDEAdapterFactoryLabelProvider
implements IDescriptionProvider,
IFontProvider {
    private static final String STATUS_LINE_PATH_SEPARATOR = "::";
    private Font _italicFont;

    public CapellaNavigatorLabelProvider() {
        super(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
    }

    public CapellaNavigatorLabelProvider(AdapterFactory adapterFact) {
        super(adapterFact);
    }

    public CapellaNavigatorLabelProvider(TransactionalEditingDomain editingDomain, AdapterFactory adapterFact) {
        super(editingDomain, adapterFact);
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof Session) {
            image = SessionLabelProviderHelper.getInstance().getSessionLabelProvider().getImage(object);
        } else if (object instanceof ItemDecorator) {
            image = ((ItemDecorator)object).getImage();
        } else if (object instanceof ViewpointItem) {
            image = CapellaNavigatorPlugin.getDefault().getImage("viewpoint.gif");
        } else if (object instanceof RepresentationDescriptionItem) {
            RepresentationDescriptionItem descriptionItem = (RepresentationDescriptionItem)object;
            image = !(descriptionItem.getWrappedObject() instanceof SequenceDiagramDescription) ? CapellaNavigatorPlugin.getDefault().getImage("diagram-type.gif") : super.getImage(((ItemWrapper)object).getWrappedObject());
        } else if (object instanceof ItemWrapper) {
            image = super.getImage(((ItemWrapper)object).getWrappedObject());
        } else if (!(object instanceof IResource)) {
            image = super.getImage(object);
        }
        return image;
    }

    public String getText(Object object) {
        String text = null;
        if (object instanceof Session) {
            text = SessionLabelProviderHelper.getInstance().getSessionLabelProvider().getText(object);
        } else if (object instanceof ItemDecorator) {
            text = ((ItemDecorator)object).getText();
        } else if (object instanceof ItemWrapper) {
            text = super.getText(((ItemWrapper)object).getWrappedObject());
        } else {
            Session session;
            IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
            String string = text = workbenchAdapter != null ? workbenchAdapter.getLabel(object) : super.getText(object);
            if (object instanceof IFile && CapellaResourceHelper.isAirdResource((IResource)((IFile)object), (boolean)true) && (session = SessionHelper.getSession((IFile)((IFile)object))) != null && session.getStatus() == SessionStatus.DIRTY) {
                text = "*" + text;
            }
        }
        return text;
    }

    public String getDescription(Object element) {
        String result = "";
        String slash = String.valueOf('/');
        if (element instanceof ModelElement) {
            ModelElement modelElement = (ModelElement)element;
            String path = modelElement.getFullLabel();
            if (path.startsWith(slash)) {
                path = path.substring(1);
            }
            result = path.replaceAll(slash, STATUS_LINE_PATH_SEPARATOR);
        } else if (element instanceof DRepresentation || element instanceof DRepresentationDescriptor) {
            DRepresentation representation = element instanceof DRepresentationDescriptor ? ((DRepresentationDescriptor)element).getRepresentation() : (DRepresentation)element;
            Object modelElement = Platform.getAdapterManager().getAdapter((Object)representation, ModelElement.class);
            if (modelElement == null) {
                modelElement = Platform.getAdapterManager().loadAdapter((Object)representation, ModelElement.class.getName());
            }
            if (modelElement != null) {
                String containerPath = this.getDescription(modelElement);
                String path = containerPath.concat(STATUS_LINE_PATH_SEPARATOR).concat(representation.getName());
                if (path.startsWith(slash)) {
                    path = path.substring(1);
                }
                result = path.replaceAll(slash, STATUS_LINE_PATH_SEPARATOR);
            }
        } else if (element instanceof ItemWrapper) {
            String description;
            ItemWrapper item = (ItemWrapper)element;
            Object wrappedObject = item.getWrappedObject();
            result = description = this.getDescription(wrappedObject);
        } else if (element instanceof Viewpoint) {
            Viewpoint viewpoint = (Viewpoint)element;
            result = viewpoint.getName();
        } else if (element instanceof RepresentationDescription) {
            RepresentationDescription description = (RepresentationDescription)element;
            String representationDescPath = description.getName();
            EObject container = description.eContainer();
            while (container != null) {
                String containerPath = this.getDescription(container);
                if (containerPath != null) {
                    representationDescPath = containerPath.concat(STATUS_LINE_PATH_SEPARATOR).concat(representationDescPath);
                }
                container = container.eContainer();
            }
            result = representationDescPath;
        } else if (element instanceof EObject) {
            String path = this.getText(element);
            Object container = ((EObject)element).eContainer();
            while (container != null) {
                String containerPath = this.getDescription(container);
                if (containerPath != null) {
                    path = containerPath.concat(STATUS_LINE_PATH_SEPARATOR).concat(path);
                }
                container = containerPath.contains(STATUS_LINE_PATH_SEPARATOR) ? null : container.eContainer();
            }
            result = path;
        }
        return result;
    }

    public void dispose() {
        if (this._italicFont != null && !this._italicFont.isDisposed()) {
            this._italicFont.dispose();
            this._italicFont = null;
        }
        super.dispose();
    }

    public Font getFont(Object element) {
        Font currentFont = Display.getCurrent().getSystemFont();
        if (this._italicFont == null) {
            FontData[] datas = currentFont.getFontData();
            datas[0].setStyle(2);
            this._italicFont = new Font(currentFont.getDevice(), datas);
        }
        if (SharedCutPasteClipboard.getCutClipboard().isObjectCut(element)) {
            return this._italicFont;
        }
        return currentFont;
    }
}

