/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ICommandStackSelectionProvider;

public class NavigatorCommandStackListener
implements CommandStackListener {
    WeakReference<Command> _mostRecent = new WeakReference<Object>(null);
    ICommandStackSelectionProvider _callback;

    public NavigatorCommandStackListener(ICommandStackSelectionProvider callback) {
        this._callback = callback;
    }

    public void commandStackChanged(EventObject event) {
        Object selectedElement;
        Collection affectedObjects;
        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        if (this._mostRecent.get() == mostRecentCommand) {
            return;
        }
        this._mostRecent = new WeakReference<Command>(mostRecentCommand);
        if (this.isRelevant(mostRecentCommand) && (affectedObjects = mostRecentCommand.getAffectedObjects()) != null && !affectedObjects.isEmpty() && (selectedElement = affectedObjects.iterator().next()) != null) {
            StructuredSelection selection = new StructuredSelection(selectedElement);
            if (mostRecentCommand instanceof RecordingCommand && mostRecentCommand.getLabel().startsWith("Delete")) {
                selection = this.handleDeleteCommand(affectedObjects);
            }
            this.selectionChanged((ISelection)selection);
        }
    }

    protected void selectionChanged(ISelection selection) {
        this._callback.commandStackSelectionChanged(selection);
    }

    protected ISelection handleDeleteCommand(Collection<?> affectedObjects) {
        ArrayList<EObject> elementsToSelect = new ArrayList<EObject>(0);
        for (Object affectedObject : affectedObjects) {
            if (!(affectedObject instanceof EObject)) continue;
            EObject parent = null;
            try {
                parent = ((EObject)affectedObject).eContainer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (parent == null) continue;
            elementsToSelect.add(parent);
        }
        return new StructuredSelection(elementsToSelect);
    }

    protected boolean shouldSelectAndReveal(RecordingCommand mostRecentCommand) {
        boolean shouldHandleMostRecentCommand = mostRecentCommand.getLabel().startsWith("Delete");
        return shouldHandleMostRecentCommand;
    }

    protected boolean isRelevant(Command mostRecentCommand) {
        if (mostRecentCommand == null) {
            return false;
        }
        boolean shouldHandleMostRecentCommand = true;
        if (mostRecentCommand instanceof SetCommand) {
            SetCommand setCommand = (SetCommand)mostRecentCommand;
            shouldHandleMostRecentCommand = !(setCommand.getValue() instanceof String);
        } else if (mostRecentCommand instanceof CompoundCommand) {
            CompoundCommand compoundCommand = (CompoundCommand)mostRecentCommand;
            for (Command command : compoundCommand.getCommandList()) {
                shouldHandleMostRecentCommand = this.isRelevant(command);
                if (shouldHandleMostRecentCommand) {
                    continue;
                }
                break;
            }
        } else {
            boolean cfr_ignored_0 = mostRecentCommand instanceof RecordingCommand;
        }
        return shouldHandleMostRecentCommand;
    }

    public void registerCommandStackListener(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
    }

    public void unregisterCommandStackListener(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        CommandStack commandStack;
        if (editingDomain != null && (commandStack = editingDomain.getCommandStack()) != null) {
            commandStack.removeCommandStackListener((CommandStackListener)this);
        }
    }
}

