/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.handlers.log;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.LogicalComponentRealization;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.transition.common.handlers.log.DefaultLogHandler;

public class CapellaLogHandler
extends DefaultLogHandler {
    public CapellaLogHandler(String reportComponent) {
        super(reportComponent);
    }

    protected String getReadableText(EObject obj) {
        String meLabel = super.getReadableText(obj);
        String text = "?";
        if (obj instanceof AbstractFunction) {
            AbstractFunction pf = (AbstractFunction)obj;
            String eltLabel = pf.getLabel() != null ? pf.getLabel() : "?";
            text = "Function : " + eltLabel;
        } else if (obj instanceof LogicalComponent) {
            LogicalComponent me = (LogicalComponent)obj;
            String eltLabel = me.getLabel() != null ? me.getLabel() : "?";
            text = "Logical Component : " + eltLabel;
        } else if (obj instanceof PhysicalComponent) {
            String eltLabel;
            PhysicalComponent pc = (PhysicalComponent)obj;
            String string = eltLabel = pc.getLabel() != null ? pc.getLabel() : "?";
            text = pc.getNature() == PhysicalComponentNature.BEHAVIOR ? "Behavioral Component : " + eltLabel : "Implementation Component : " + eltLabel;
        } else if (obj instanceof AbstractActor) {
            AbstractActor actor = (AbstractActor)obj;
            String eltLabel = actor.getLabel() != null ? actor.getLabel() : "?";
            text = "Actor : " + eltLabel;
        } else if (obj instanceof Part) {
            Part part = (Part)obj;
            String eltLabel = part.getLabel() != null ? part.getLabel() : "?";
            text = "Part : " + eltLabel;
        } else if (obj instanceof PhysicalLink) {
            PhysicalLink pl = (PhysicalLink)obj;
            String eltLabel = pl.getLabel() != null ? pl.getLabel() : "?";
            text = "Physical Link : " + eltLabel;
        } else if (obj instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)obj;
            String eltLabel = fe.getLabel() != null ? fe.getLabel() : "?";
            String feSource = fe.getSource() != null ? EObjectLabelProviderHelper.getText((EObject)fe.getSource().eContainer()) : "?";
            String feTarget = fe.getTarget() != null ? EObjectLabelProviderHelper.getText((EObject)fe.getTarget().eContainer()) : "?";
            text = "Functional Exchange : " + eltLabel + " between " + feSource + " and " + feTarget;
        } else if (obj instanceof ComponentExchange) {
            ComponentExchange c = (ComponentExchange)obj;
            String eltLabel = c.getLabel() != null ? c.getLabel() : "?";
            String cSource = c.getSource() != null ? EObjectLabelProviderHelper.getText((EObject)c.getSource().eContainer()) : "?";
            String cTarget = c.getTarget() != null ? EObjectLabelProviderHelper.getText((EObject)c.getTarget().eContainer()) : "?";
            text = "Component Exchange : " + eltLabel + " between " + cSource + " and " + cTarget;
        } else if (obj instanceof PartDeploymentLink) {
            PartDeploymentLink pdl = (PartDeploymentLink)obj;
            String source = pdl.getDeployedElement() != null ? pdl.getDeployedElement().getLabel() : "?";
            String target = pdl.getLocation() != null ? pdl.getLocation().getLabel() : "?";
            text = "Deployment Link : " + source + " -> " + target;
        } else if (obj instanceof ComponentFunctionalAllocation) {
            ComponentFunctionalAllocation cfa = (ComponentFunctionalAllocation)obj;
            String source = cfa.getTargetElement() != null ? cfa.getTargetElement().getLabel() : "?";
            String target = cfa.getSourceElement() != null ? cfa.getSourceElement().getLabel() : "?";
            text = "Functional Allocation : " + source + " -> " + target;
        } else if (obj instanceof ComponentExchangeAllocation) {
            ComponentExchangeAllocation ca = (ComponentExchangeAllocation)obj;
            String source = ca.getTargetElement() != null ? ca.getTargetElement().getLabel() : "?";
            String target = ca.getSourceElement() != null ? ca.getSourceElement().getLabel() : "?";
            text = "Component Exchange Allocation : " + source + " -> " + target;
        } else if (obj instanceof ComponentExchangeFunctionalExchangeAllocation) {
            ComponentExchangeFunctionalExchangeAllocation cfea = (ComponentExchangeFunctionalExchangeAllocation)obj;
            String source = cfea.getTargetElement() != null ? cfea.getTargetElement().getLabel() : "?";
            String target = cfea.getSourceElement() != null ? cfea.getSourceElement().getLabel() : "?";
            text = "Functional Exchange Allocation : " + source + " -> " + target;
        } else if (obj instanceof Port) {
            Port me = (Port)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "Port : " + name;
        } else if (obj instanceof DataType) {
            DataType me = (DataType)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "DataType : " + name;
        } else if (obj instanceof BlockArchitecture) {
            BlockArchitecture me = (BlockArchitecture)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "Architecture : " + name;
        } else if (obj instanceof AbstractCapability) {
            AbstractCapability me = (AbstractCapability)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "Capability : " + name;
        } else if (obj instanceof Structure) {
            Structure me = (Structure)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "Package : " + name;
        } else if (obj instanceof ComponentContext) {
            ComponentContext me = (ComponentContext)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "Context : " + name;
        } else if (obj instanceof System) {
            System me = (System)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "System : " + name;
        } else if (obj instanceof DataValue) {
            String name = meLabel != null ? meLabel : "?";
            text = "DataValue : " + name;
        } else if (obj instanceof StateMachine) {
            StateMachine me = (StateMachine)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "StateMachine : " + name;
        } else if (obj instanceof Region) {
            Region me = (Region)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "Region : " + name;
        } else if (obj instanceof ExchangeItem) {
            ExchangeItem me = (ExchangeItem)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "ExchangeItem : " + name;
        } else if (obj instanceof ExchangeItemElement) {
            ExchangeItemElement me = (ExchangeItemElement)obj;
            String name = me.getName() != null ? me.getName() : "?";
            text = "ExchangeItem Element : " + name;
        } else if (meLabel != null) {
            text = meLabel;
        }
        return text;
    }

    public String getIdentifier(EObject me) {
        if (me instanceof AbstractFunction) {
            return DiffElement.Fct.toString();
        }
        if (me instanceof PhysicalComponent) {
            PhysicalComponent pc = (PhysicalComponent)me;
            if (pc.getNature() == PhysicalComponentNature.BEHAVIOR) {
                return DiffElement.BC.toString();
            }
            return DiffElement.IC.toString();
        }
        if (me instanceof AbstractActor) {
            return DiffElement.Actor.toString();
        }
        if (me instanceof Part) {
            return DiffElement.Part.toString();
        }
        if (me instanceof PhysicalLink) {
            return DiffElement.PL.toString();
        }
        if (me instanceof FunctionalExchange) {
            return DiffElement.FE.toString();
        }
        if (me instanceof ComponentExchange) {
            return DiffElement.CE.toString();
        }
        if (me instanceof PartDeploymentLink) {
            return DiffElement.DL.toString();
        }
        if (me instanceof ComponentFunctionalAllocation) {
            return DiffElement.FA.toString();
        }
        if (me instanceof ComponentExchangeAllocation) {
            return DiffElement.CA.toString();
        }
        if (me instanceof ComponentExchangeFunctionalExchangeAllocation) {
            return DiffElement.FEA.toString();
        }
        if (me instanceof FunctionPort) {
            return DiffElement.FPort.toString();
        }
        if (me instanceof ComponentPort) {
            return DiffElement.CPort.toString();
        }
        if (me instanceof PhysicalPort) {
            return DiffElement.PPort.toString();
        }
        if (me instanceof FunctionRealization) {
            return DiffElement.FR.toString();
        }
        if (me instanceof LogicalComponentRealization) {
            return DiffElement.LCR.toString();
        }
        if (me instanceof LogicalArchitectureRealization) {
            return DiffElement.Other.toString();
        }
        if (me instanceof DataValue) {
            return DiffElement.Data.toString();
        }
        if (me instanceof ExchangeItem || me instanceof ExchangeItemElement) {
            return DiffElement.EI.toString();
        }
        if (me instanceof Interface) {
            return DiffElement.Iface.toString();
        }
        if (me instanceof Region || me instanceof Mode || me instanceof StateMachine || me instanceof State || me instanceof StateTransition) {
            return DiffElement.MS.toString();
        }
        if (me instanceof TransfoLink) {
            return DiffElement.Other.toString();
        }
        return DiffElement.Other.toString();
    }

    public static enum DiffElement {
        Fct,
        BC,
        IC,
        Actor,
        Part,
        FE,
        CE,
        PL,
        DL,
        FA,
        CA,
        FEA,
        FR,
        LCR,
        FPort,
        CPort,
        PPort,
        EI,
        Iface,
        Data,
        MS,
        Other;

    }
}

