/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.handlers.traceability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.transition.common.handlers.session.SessionHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.LinkTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class SIDTraceabilityHandler
extends LinkTraceabilityHandler {
    public static final EAttribute PROPERTY_SID = ModellingcorePackage.Literals.MODEL_ELEMENT__SID;

    public EAttribute getAttribute(IContext context) {
        return PROPERTY_SID;
    }

    public SIDTraceabilityHandler(String identifier) {
        super(identifier);
    }

    protected List<EObject> getSourceAttachments(EObject targetElement, IContext context) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        EObject result = null;
        if (targetElement instanceof CapellaElement) {
            for (String id : this.getSourceIds(targetElement, context)) {
                result = SessionHandlerHelper.getInstance((IContext)context).getEObjectFromId(id, context);
                if (result == null) continue;
                elements.add(result);
            }
        }
        return elements;
    }

    protected List<String> getSourceIds(EObject targetElement, IContext context) {
        ArrayList<String> ids = new ArrayList<String>();
        if (targetElement instanceof CapellaElement) {
            String[] values;
            EAttribute attribute = this.getAttribute(context);
            String propertyValue = (String)targetElement.eGet((EStructuralFeature)attribute);
            propertyValue = propertyValue == null ? "" : propertyValue;
            String[] stringArray = values = propertyValue.split(";");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value != null && value.length() > 0) {
                    ids.add(value);
                }
                ++n2;
            }
        }
        return ids;
    }

    public void attachTraceability(EObject sourceElement, EObject targetElement, IContext context) {
        if (targetElement != null) {
            this.createAttachment(sourceElement, targetElement, context);
        }
    }

    protected void createAttachment(EObject sourceElement, EObject targetElement, IContext context) {
        List<String> ids;
        EAttribute attribute = this.getAttribute(context);
        String propertyValue = (String)targetElement.eGet((EStructuralFeature)attribute);
        ArrayList<String> values = new ArrayList<String>();
        if (propertyValue != null && propertyValue.length() > 0) {
            values.addAll(Arrays.asList(propertyValue.split(";")));
        }
        if ((ids = this.getSourceIds(sourceElement, context)).size() == 0) {
            String id = SessionHandlerHelper.getInstance((IContext)context).getId(sourceElement, context);
            ids.add(id);
            if (sourceElement.eGet((EStructuralFeature)attribute) == null) {
                sourceElement.eSet((EStructuralFeature)attribute, (Object)id);
            }
        }
        this.addMappings(sourceElement, targetElement, context);
        for (String id : ids) {
            if (!values.contains(id)) {
                values.add(id);
                continue;
            }
            return;
        }
        String result = "";
        int i = 0;
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            result = String.valueOf(result) + value;
            if (++i >= values.size()) continue;
            result = String.valueOf(result) + ";";
        }
        targetElement.eSet((EStructuralFeature)attribute, (Object)result);
    }
}

