/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.rules.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.constants.Messages;
import org.polarsys.capella.core.transition.system.rules.AbstractCapellaElementRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class InvolvementRule
extends AbstractCapellaElementRule {
    @Override
    protected EClass getSourceType() {
        return CapellacorePackage.Literals.INVOLVEMENT;
    }

    protected void retrieveRequired(EObject element, List<EObject> result, IContext context) {
        super.retrieveRequired(element, result, context);
        result.add((EObject)((Involvement)element).getInvolved());
        result.add((EObject)((Involvement)element).getInvolver());
    }

    @Override
    protected void premicesRelated(EObject eObject1, ArrayList<IPremise> needed) {
        super.premicesRelated(eObject1, needed);
        Involvement element = (Involvement)eObject1;
        needed.addAll(this.createDefaultPrecedencePremices((EObject)element, CapellacorePackage.Literals.INVOLVEMENT__INVOLVED));
        needed.addAll(this.createDefaultPrecedencePremices((EObject)element, CapellacorePackage.Literals.INVOLVEMENT__INVOLVER));
    }

    protected void retrieveContainer(EObject element, List<EObject> result, IContext context) {
    }

    @Override
    protected void attachRelated(EObject element, EObject result, IContext context) {
        super.attachRelated(element, result, context);
        AttachmentHelper.getInstance((IContext)context).attachTracedElements(element, result, CapellacorePackage.Literals.INVOLVEMENT__INVOLVED, context);
        AttachmentHelper.getInstance((IContext)context).attachTracedElements(element, result, CapellacorePackage.Literals.INVOLVEMENT__INVOLVER, context);
    }

    public IStatus transformRequired(EObject element, IContext context) {
        IStatus result = super.transformRequired(element, context);
        if (result.isOK()) {
            Involvement ce = (Involvement)element;
            if (ce.getInvolved() == null) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, Messages.SourceNull);
            }
            if (ce.getInvolver() == null) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, Messages.TargetNull);
            }
            if (!TransformationHandlerHelper.getInstance((IContext)context).isOrWillBeTransformed((EObject)ce.getInvolved(), context).isOK()) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, NLS.bind((String)Messages.SourceBoundNotTransitioned, (Object)EObjectLabelProviderHelper.getText((EObject)ce.getInvolved())));
            }
            if (!TransformationHandlerHelper.getInstance((IContext)context).isOrWillBeTransformed((EObject)ce.getInvolver(), context).isOK()) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, NLS.bind((String)Messages.TargetBoundNotTransitioned, (Object)EObjectLabelProviderHelper.getText((EObject)ce.getInvolver())));
            }
        }
        return result;
    }
}

