/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.epbs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConfigurationItemKind implements Enumerator
{
    UNSET(0, "Unset", "Unset"),
    COTSCI(1, "COTSCI", "COTSCI"),
    CSCI(2, "CSCI", "CSCI"),
    HWCI(3, "HWCI", "HWCI"),
    INTERFACE_CI(4, "InterfaceCI", "InterfaceCI"),
    NDICI(5, "NDICI", "NDICI"),
    PRIME_ITEM_CI(6, "PrimeItemCI", "PrimeItemCI"),
    SYSTEM_CI(7, "SystemCI", "SystemCI");

    public static final int UNSET_VALUE = 0;
    public static final int COTSCI_VALUE = 1;
    public static final int CSCI_VALUE = 2;
    public static final int HWCI_VALUE = 3;
    public static final int INTERFACE_CI_VALUE = 4;
    public static final int NDICI_VALUE = 5;
    public static final int PRIME_ITEM_CI_VALUE = 6;
    public static final int SYSTEM_CI_VALUE = 7;
    private static final ConfigurationItemKind[] VALUES_ARRAY;
    public static final List<ConfigurationItemKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConfigurationItemKind[]{UNSET, COTSCI, CSCI, HWCI, INTERFACE_CI, NDICI, PRIME_ITEM_CI, SYSTEM_CI};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConfigurationItemKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConfigurationItemKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConfigurationItemKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConfigurationItemKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConfigurationItemKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return COTSCI;
            }
            case 2: {
                return CSCI;
            }
            case 3: {
                return HWCI;
            }
            case 4: {
                return INTERFACE_CI;
            }
            case 5: {
                return NDICI;
            }
            case 6: {
                return PRIME_ITEM_CI;
            }
            case 7: {
                return SYSTEM_CI;
            }
        }
        return null;
    }

    private ConfigurationItemKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

