/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.extension.ExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.ExpressionInterpreter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.ExpressionKind;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.OCLExpressionNotSupported;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.ViewpointResourceProviderRegistry;

public class SiriusExpressionHelper {
    public static ExpressionKind getCurrentExpressionKind() {
        Viewpoint viewpoint = ViewpointResourceProviderRegistry.getInstance().getViewpoint();
        return ExtensionManager.getDiagramExpressionLanguageFilters((EObject)viewpoint);
    }

    public static String getEdgeSemanticTarget(boolean source) {
        ExpressionKind currentExpressionKind = SiriusExpressionHelper.getCurrentExpressionKind();
        if (source) {
            switch (currentExpressionKind) {
                case QueryLegacy: {
                    return "sourceNode.target";
                }
                case Acceleo_3_x: {
                    return "sourceNode.oclAsType(viewpoint::DSemanticDecorator).target";
                }
                case Ocl: {
                    throw new OCLExpressionNotSupported();
                }
            }
        } else {
            switch (currentExpressionKind) {
                case QueryLegacy: {
                    return "targetNode.target";
                }
                case Acceleo_3_x: {
                    return "targetNode.oclAsType(viewpoint::DSemanticDecorator).target";
                }
                case Ocl: {
                    throw new OCLExpressionNotSupported();
                }
            }
        }
        return "";
    }

    public static String getExpressoin(String expression) {
        ExpressionKind kind = SiriusExpressionHelper.getCurrentExpressionKind();
        return kind.format(expression);
    }

    public static String getExpressoin(String expression, ExpressionInterpreter interpreter) {
        return interpreter.format(expression);
    }

    public static String getConcatenationCharacter() {
        ExpressionKind currentExpressionKind = SiriusExpressionHelper.getCurrentExpressionKind();
        return currentExpressionKind.getConcatenationCharacter();
    }

    public static String getInnerFeature(String featureName) {
        switch (SiriusExpressionHelper.getCurrentExpressionKind()) {
            case QueryLegacy: {
                return "<%" + featureName + "%>";
            }
            case Acceleo_3_x: {
                return featureName;
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException();
    }

    public static String getInnerJavaService(String serviceName) {
        switch (SiriusExpressionHelper.getCurrentExpressionKind()) {
            case QueryLegacy: {
                return "<%" + serviceName + "%>";
            }
            case Acceleo_3_x: {
                return serviceName;
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException();
    }

    public static String getInnerVariable(String variableName) {
        switch (SiriusExpressionHelper.getCurrentExpressionKind()) {
            case QueryLegacy: {
                return SiriusExpressionHelper.variableHasPrefix(variableName) ? variableName : "$" + variableName;
            }
            case Acceleo_3_x: {
                return SiriusExpressionHelper.getVariableWithoutPrefix(variableName);
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException();
    }

    public static String formatString(String string) {
        if (ExpressionInterpreter.isInterpreterExpression(string)) {
            return string;
        }
        switch (SiriusExpressionHelper.getCurrentExpressionKind()) {
            case QueryLegacy: {
                return string;
            }
            case Acceleo_3_x: {
                return SiriusExpressionHelper.stringHasAcceleo3Delimiters(string) ? string : String.valueOf('\'') + string + '\'';
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException();
    }

    private static boolean stringHasAcceleo3Delimiters(String string) {
        return string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'';
    }

    private static String getVariableWithoutPrefix(String variableName) {
        if (SiriusExpressionHelper.variableHasPrefix(variableName)) {
            return variableName.substring(1, variableName.length());
        }
        return variableName;
    }

    private static boolean variableHasPrefix(String variableName) {
        return variableName != null && variableName.length() > 0 ? variableName.startsWith("$") : false;
    }
}

