/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.command.recorder.ui.handler;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.polarsys.capella.common.command.recorder.core.RecorderCoreActivator;
import org.polarsys.capella.common.command.recorder.core.exception.RecorderException;
import org.polarsys.capella.common.command.recorder.core.manager.IRecorderManager;
import org.polarsys.capella.common.command.recorder.core.preferences.RecorderCorePreferenceServices;
import org.polarsys.capella.core.command.recorder.internal.CapellaProjectRecorderManager;
import org.polarsys.capella.core.command.recorder.internal.utils.CapellaProjectUtils;

public class CapellaRecorderHandler
implements IEclipsePreferences.IPreferenceChangeListener {
    public static CapellaRecorderHandler INSTANCE = new CapellaRecorderHandler();
    IRecorderManager _recorderManager = null;
    protected IEclipsePreferences _node = new InstanceScope().getNode(RecorderCoreActivator.getDefault().getPluginId());

    private void initRecorderManager() {
        if (this._recorderManager == null) {
            Set<String> natures = Collections.singleton(CapellaProjectUtils.getCapellaProjectNatureId());
            this._recorderManager = new CapellaProjectRecorderManager(natures);
        }
    }

    public void startUp() {
        this.initRecorderManager();
        try {
            if (RecorderCorePreferenceServices.isRecorderShouldBeRunning()) {
                this._recorderManager.startup();
            } else {
                this._recorderManager.shutDown();
            }
        }
        catch (RecorderException recorderException) {
            // empty catch block
        }
    }

    public IRecorderManager getRecorder() {
        return this._recorderManager;
    }

    protected CapellaRecorderHandler() {
        this._node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event_p) {
        block8: {
            if (event_p.getKey().equals("recorder_state_pref")) {
                boolean newState = RecorderCorePreferenceServices.isRecorderShouldBeRunning();
                this.initRecorderManager();
                try {
                    if (newState) {
                        this._recorderManager.startup();
                        break block8;
                    }
                    this._recorderManager.shutDown();
                }
                catch (RecorderException recorderException) {}
            } else if (event_p.getKey().equals("recorder_root_path_pref")) {
                try {
                    this._recorderManager.shutDown();
                    this._recorderManager.startup();
                }
                catch (RecorderException recorderException) {
                    // empty catch block
                }
            }
        }
    }
}

