/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report;

import java.util.ArrayList;
import java.util.List;

public class EmbeddedMessage {
    private String _label;
    private String _componentName;
    private List<Object> _capellaElements = new ArrayList<Object>();
    private String _source;

    public EmbeddedMessage(String label, String componentName) {
        this.setLabel(label);
        this.setComponentName(componentName);
    }

    public EmbeddedMessage(String label, String componentName, List<Object> capellaElements) {
        this(label, componentName);
        this.setCapellaElements(capellaElements);
    }

    public EmbeddedMessage(String label, String componentName, Object capellaElements) {
        this(label, componentName);
        if (capellaElements != null) {
            if (capellaElements instanceof List) {
                this.setCapellaElements((List)capellaElements);
            } else {
                ArrayList<Object> objets = new ArrayList<Object>();
                if (capellaElements instanceof Object[]) {
                    Object[] objectArray = (Object[])capellaElements;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof List) {
                            objets.addAll((List)obj);
                        } else {
                            objets.add(obj);
                        }
                        ++n2;
                    }
                } else {
                    objets.add(capellaElements);
                }
                this.setCapellaElements(objets);
            }
        }
    }

    public String toString() {
        StringBuffer containsMessage = new StringBuffer();
        containsMessage.append("[" + this.getComponentName() + "]\t");
        if (this.getComponentName().length() < 9) {
            containsMessage.append('\t');
        }
        containsMessage.append(this.getLabel());
        if (this._capellaElements != null && this._capellaElements.size() > 0) {
            containsMessage.append(" - Object(s) list : \n");
            for (Object theElement : this._capellaElements) {
                if (theElement == null) continue;
                containsMessage.append(this.getName(theElement));
                containsMessage.append("\n");
            }
        }
        return containsMessage.toString();
    }

    private String getName(Object theElement) {
        String name = null;
        try {
            try {
                name = (String)theElement.getClass().getMethod("getFullLabel", new Class[0]).invoke(theElement, (Object[])new Class[0]);
            }
            catch (Throwable throwable) {
                if (name == null) {
                    name = theElement.toString();
                }
            }
        }
        finally {
            if (name == null) {
                name = theElement.toString();
            }
        }
        return name;
    }

    public String getComponentName() {
        return this._componentName;
    }

    public void setComponentName(String componentName) {
        this._componentName = componentName;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public List<Object> getCapellaElements() {
        return this._capellaElements;
    }

    public void setCapellaElements(List<Object> capellaElements) {
        this._capellaElements = capellaElements;
    }

    @Deprecated
    public void setInfo(String info) {
        this.setSource(info);
    }

    public void setSource(String source) {
        this._source = source;
    }

    public String getSource() {
        return this._source;
    }

    public boolean equals(Object ob) {
        if (ob instanceof EmbeddedMessage) {
            EmbeddedMessage newOb = (EmbeddedMessage)ob;
            boolean notEquElts = true;
            for (Object currentElt : this.getCapellaElements()) {
                for (Object newObElt : newOb.getCapellaElements()) {
                    boolean bl = notEquElts = !currentElt.equals(newObElt);
                }
            }
            return this.getComponentName().equals(newOb.getComponentName()) && this.getLabel().equals(newOb.getLabel()) && !notEquElts;
        }
        return false;
    }

    @Deprecated
    public void adapt(Object target) {
    }
}

