/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.registry;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Logger;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.spi.Filter;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.EmbeddedMessageRenderer;
import org.polarsys.capella.common.tools.report.ReportManagerActivator;
import org.polarsys.capella.common.tools.report.appenders.IFlushableAppenders;
import org.polarsys.capella.common.tools.report.appenders.ReportManagerFilter;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.CreateXmlConfiguration;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;

public class ReportManagerRegistry {
    private Map<String, ConfigurationInstance> _configurations = new HashMap<String, ConfigurationInstance>(1);
    private Map<String, Appender> _appenders = new HashMap<String, Appender>(1);
    private static ReportManagerRegistry instance;

    protected ReportManagerRegistry() {
        this.initRootLogger();
        CreateXmlConfiguration configuration = new CreateXmlConfiguration();
        ConfigurationInstance defaultConfInstance = configuration.createDefaultConfiguration("Default", this._appenders);
        this._configurations.put(defaultConfInstance.getComponentName(), defaultConfInstance);
        if (configuration.isConfigurationFileExists()) {
            HashMap<String, ConfigurationInstance> persistedConfs = configuration.loadConfiguration();
            HashMap<String, ConfigurationInstance> virtualConfs = new HashMap<String, ConfigurationInstance>(1);
            for (Map.Entry<String, ConfigurationInstance> confEntry : persistedConfs.entrySet()) {
                ConfigurationInstance newVirtualConf = configuration.createDefaultConfiguration(confEntry.getKey(), this._appenders);
                this.copyValuesOfConfigurationInstance(confEntry.getValue(), newVirtualConf);
                virtualConfs.put(confEntry.getKey(), newVirtualConf);
            }
            this._configurations.putAll(virtualConfs);
        }
        this.setConfigurations(this._configurations);
    }

    public static synchronized ReportManagerRegistry getInstance() {
        if (instance == null) {
            instance = new ReportManagerRegistry();
            instance.subscribe("Default");
        }
        return instance;
    }

    protected ConfigurationInstance copyConfig(ConfigurationInstance source) {
        ConfigurationInstance target = new ConfigurationInstance();
        target.setComponentName(source.getComponentName());
        List<OutputConfiguration> tgtOutputConfs = target.getOutputConfiguration();
        for (OutputConfiguration srcOutputConf : source.getOutputConfiguration()) {
            OutputConfiguration tgtOutputConf = new OutputConfiguration();
            tgtOutputConf.setOutputName(srcOutputConf.getOutputName());
            List<LogLevel> tgtLogLevels = tgtOutputConf.getLogLevel();
            for (LogLevel srcLogLevel : srcOutputConf.getLogLevel()) {
                LogLevel tgtLogLevel = new LogLevel();
                tgtLogLevel.setName(srcLogLevel.getName());
                tgtLogLevel.setValue(srcLogLevel.isValue());
                tgtLogLevels.add(tgtLogLevel);
            }
            tgtOutputConfs.add(tgtOutputConf);
        }
        return target;
    }

    protected void copyValuesOfConfigurationInstance(ConfigurationInstance source, ConfigurationInstance target) {
        if (source.getComponentName() != null && source.getComponentName().equals(target.getComponentName())) {
            this.copyValuesOfOutputConfiguration(source, target);
        }
    }

    protected void copyValuesOfOutputConfiguration(ConfigurationInstance source, ConfigurationInstance target) {
        block0: for (OutputConfiguration srcOutputConf : source.getOutputConfiguration()) {
            for (OutputConfiguration tgtOutputConf : target.getOutputConfiguration()) {
                if (srcOutputConf.getOutputName() == null || !srcOutputConf.getOutputName().equals(tgtOutputConf.getOutputName())) continue;
                this.copyValuesOfLogLevels(srcOutputConf, tgtOutputConf);
                continue block0;
            }
        }
    }

    protected void copyValuesOfLogLevels(OutputConfiguration srcOutputConf, OutputConfiguration tgtOutputConf) {
        block0: for (LogLevel srcLogLevel : srcOutputConf.getLogLevel()) {
            for (LogLevel tgtLogLevel : tgtOutputConf.getLogLevel()) {
                if (!srcLogLevel.getName().equals(tgtLogLevel.getName())) continue;
                tgtLogLevel.setValue(srcLogLevel.isValue());
                continue block0;
            }
        }
    }

    protected void initRootLogger() {
        try {
            Logger root = Logger.getRootLogger();
            ReportManagerActivator act = ReportManagerActivator.getDefault();
            List<Appender> theAppenders = act.getAppenders();
            for (Appender appender : theAppenders) {
                root.addAppender(appender);
                if (this._appenders.containsKey(appender.getName())) continue;
                this._appenders.put(appender.getName(), appender);
            }
            Hierarchy h = (Hierarchy)Logger.getRootLogger().getLoggerRepository();
            EmbeddedMessageRenderer emRenderer = new EmbeddedMessageRenderer();
            h.addRenderer(EmbeddedMessage.class, (ObjectRenderer)emRenderer);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender currentApp = (Appender)appenders.nextElement();
            currentApp.clearFilters();
            currentApp.addFilter((Filter)new ReportManagerFilter(currentApp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger subscribe(String componentName) {
        ConfigurationInstance oConfigurationInstance;
        if (!this._configurations.containsKey(componentName) && (oConfigurationInstance = this.copyConfig(this._configurations.get("Default"))) != null) {
            oConfigurationInstance.setComponentName(componentName);
            Map<String, ConfigurationInstance> map = this._configurations;
            synchronized (map) {
                this._configurations.put(componentName, oConfigurationInstance);
            }
        }
        Logger theLog = Logger.getLogger((String)componentName);
        return theLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(String componentName) {
        if (this._configurations.containsKey(componentName)) {
            Map<String, ConfigurationInstance> map = this._configurations;
            synchronized (map) {
                this._configurations.remove(componentName);
            }
        }
    }

    protected List<IFlushableAppenders> getFlushableAppenders() {
        ReportManagerActivator act = ReportManagerActivator.getDefault();
        List<IFlushableAppenders> theAppenders = act.getFlushableAppenders();
        return theAppenders;
    }

    public void beginLoggingSession() {
        this.beginLoggingSession("ALL");
    }

    public void beginLoggingSession(String componentName) {
        this.beginLoggingSession(componentName, null);
    }

    public void beginLoggingSession(String componentName, Object loggedElement) {
        for (IFlushableAppenders _appender : this.getFlushableAppenders()) {
            _appender.flush(componentName, loggedElement);
        }
    }

    public Object[] getComponentsList() {
        return this._configurations.keySet().toArray();
    }

    public ConfigurationInstance getComponentConfiguration(String componentName) {
        ConfigurationInstance oConfigurationInstance = this._configurations.get(componentName);
        if (oConfigurationInstance != null) {
            return oConfigurationInstance;
        }
        return oConfigurationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration() {
        CreateXmlConfiguration configuration = new CreateXmlConfiguration();
        Map<String, ConfigurationInstance> map = this._configurations;
        synchronized (map) {
            configuration.saveConfiguration(this._configurations);
        }
    }

    public Map<String, ConfigurationInstance> getConfigurations() {
        return this._configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurations(Map<String, ConfigurationInstance> map) {
        Map<String, ConfigurationInstance> map2 = this._configurations;
        synchronized (map2) {
            this._configurations = map;
        }
    }

    public String toString() {
        return "ReportManager";
    }

    public Map<String, Appender> getAppenders() {
        return this._appenders;
    }
}

