/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ProjectUtils;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.WorkspaceManager;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointView;

public class ProjectSelectionListener
implements ISelectionListener {
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sselection = (IStructuredSelection)selection;
        if (sselection.size() > 1) {
            return;
        }
        if (part instanceof ViewpointView) {
            return;
        }
        if (sselection.isEmpty()) {
            this.projectSelected(null);
        } else {
            this.analyseElement(sselection.getFirstElement());
        }
    }

    private void analyseElement(Object firstElement) {
        IProject project;
        if (firstElement instanceof IResource) {
            IResource res = (IResource)firstElement;
            project = res.getProject();
            this.projectSelected(project);
        }
        if (firstElement instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)firstElement;
            IResource res = (IResource)adaptable.getAdapter(IResource.class);
            if (res == null) {
                return;
            }
            IProject project2 = res.getProject();
            this.projectSelected(project2);
        }
        if (firstElement instanceof EObject) {
            EObject eobj = (EObject)firstElement;
            project = ProjectUtils.getContainingProject((EObject)eobj);
            this.projectSelected(project);
        }
    }

    private void projectSelected(IProject project) {
        WorkspaceManager.INSTANCE.projectSelected(project);
    }
}

