/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewElement;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ViewHelper {
    public static void openViews(Resource resource) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        for (ViewElement current : ViewHelper.getViewIds(resource)) {
            try {
                activePage.showView(current.getId());
            }
            catch (PartInitException e) {
                AD_Log.getDefault().logError((Throwable)e);
            }
        }
    }

    public static List<ViewElement> getViewIds(Resource resource) {
        ArrayList<ViewElement> viewIds = new ArrayList<ViewElement>();
        String providerSymbolicName = resource.getProviderSymbolicName();
        IPluginModelBase bundle = PluginRegistry.findModel((String)providerSymbolicName);
        if (bundle == null) {
            return viewIds;
        }
        IPluginExtension[] iPluginExtensionArray = bundle.getExtensions().getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            if ("org.eclipse.ui.views".equals(extension.getPoint())) {
                IPluginObject[] iPluginObjectArray = extension.getChildren();
                int n3 = iPluginObjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    PluginElement elt;
                    IPluginObject children = iPluginObjectArray[n4];
                    if (children instanceof PluginElement && (elt = (PluginElement)children).getAttribute("resourceId") != null && elt.getAttribute("id") != null) {
                        String id = elt.getAttribute("id").getValue();
                        String name = elt.getAttribute("name").getValue();
                        name = name == null || name.isEmpty() ? id : name;
                        ViewElement view = new ViewElement(id, name);
                        viewIds.add(view);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return viewIds;
    }
}

