/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.metamodels;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointEditPlugin;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IMetamodelHandler;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.dialogs.EditorHelper;
import org.polarsys.kitalpha.ad.viewpoint.ui.dialogs.ModelFileDialog;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AbstractTab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.ResourceTableSorter;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.metamodels.MetamodelContentProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.metamodels.MetamodelLabelProvider;

public class MetamodelTab
extends AbstractTab {
    private static final String NAME_COLUMN = "name";
    private TableViewer metamodelViewer;
    private Button addBtn;
    private Button deleteBtn;
    private Button viewBtn;

    public MetamodelTab() {
        super(new MetamodelLabelProvider());
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.metamodelViewer;
    }

    @Override
    public void createTab(FormToolkit toolkit, CTabFolder folder) {
        Composite composite = this.createTab(toolkit, folder, Messages.MetamodelTab_title, ViewpointEditPlugin.INSTANCE.getImage("full/obj16/Metamodel"));
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 2;
        composite.setLayout((Layout)clayout);
        this.metamodelViewer = new TableViewer(composite, 67584);
        final Table table = this.metamodelViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        AbstractTab.SelectionListener2 headerListener = new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                TableColumn newSortColumn;
                TableColumn currentSortColumn = table.getSortColumn();
                if (currentSortColumn.equals(newSortColumn = (TableColumn)e.getSource())) {
                    int sortDirection = table.getSortDirection();
                    table.setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    table.setSortColumn(newSortColumn);
                    table.setSortDirection(1024);
                }
                MetamodelTab.this.metamodelViewer.refresh();
            }
        };
        TableViewerColumn nameColumn = new TableViewerColumn(this.metamodelViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 90, true));
        nameColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        nameColumn.getColumn().setText(Messages.MetamodelTab_column_path_label);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setData((Object)0);
        table.setSortColumn(nameColumn.getColumn());
        table.setSortDirection(1024);
        this.metamodelViewer.setColumnProperties(new String[]{NAME_COLUMN});
        this.metamodelViewer.setContentProvider((IContentProvider)MetamodelContentProvider.INSTANCE);
        this.metamodelViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.metamodelViewer.setSorter((ViewerSorter)new ResourceTableSorter());
        Composite btnBar = toolkit.createComposite(composite);
        btnBar.setLayout((Layout)new GridLayout());
        this.addBtn = toolkit.createButton(btnBar, "", 8);
        this.addBtn.setToolTipText(Messages.MetamodelTab_add_tooltip);
        this.addBtn.setImage(Activator.getDefault().getImage("icons/add.gif"));
        this.addBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IMetamodelHandler metamodelHandler = MetamodelTab.this.modelManager.getMetamodelHandler();
                URI uri = MetamodelTab.this.viewpoint.eResource().getURI();
                String segment = uri.segment(1);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = root.getProject(segment);
                ModelFileDialog dialog = new ModelFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MetamodelTab.this.viewpoint, "*.ecore");
                if (dialog.open() == 0) {
                    ResourceSet resourceSet = MetamodelTab.this.viewpoint.eResource().getResourceSet();
                    ArrayList<EPackage> packages = new ArrayList<EPackage>();
                    for (URI euri : dialog.getResult()) {
                        Resource resource = resourceSet.getResource(euri, true);
                        for (EObject eobj : resource.getContents()) {
                            if (!(eobj instanceof EPackage)) continue;
                            packages.add((EPackage)eobj);
                        }
                    }
                    metamodelHandler.addMetamodels(packages);
                }
            }
        });
        this.deleteBtn = toolkit.createButton(btnBar, "", 8);
        this.deleteBtn.setToolTipText(Messages.MetamodelTab_delete_tooltip);
        this.deleteBtn.setImage(Activator.getDefault().getImage("icons/delete.gif"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetamodelTab.this.metamodelViewer.getSelection();
                ArrayList<EPackage> packages = new ArrayList<EPackage>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    packages.add((EPackage)obj);
                    ++n2;
                }
                IMetamodelHandler metamodelHandler = MetamodelTab.this.modelManager.getMetamodelHandler();
                metamodelHandler.removeMetamodels(packages);
            }
        });
        this.viewBtn = toolkit.createButton(btnBar, "", 8);
        this.viewBtn.setToolTipText(Messages.MetamodelTab_view_tooltip);
        this.viewBtn.setImage(Activator.getDefault().getImage("icons/viewFile.gif"));
        this.viewBtn.setEnabled(false);
        this.viewBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetamodelTab.this.metamodelViewer.getSelection();
                EObject obj = (EObject)selection.getFirstElement();
                URI uri = obj.eResource().getURI();
                try {
                    EditorHelper.openEditor(uri);
                }
                catch (PartInitException e1) {
                    Activator.getDefault().logError(e1);
                }
            }
        });
        this.metamodelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MetamodelTab.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
    }

    @Override
    public void init() {
        IMetamodelHandler metamodelHandler = this.modelManager.getMetamodelHandler();
        if (metamodelHandler != null) {
            this.metamodelViewer.setInput((Object)metamodelHandler);
        }
        this.workspaceHasChanged();
    }

    @Override
    public void workspaceHasChanged() {
        super.workspaceHasChanged();
        this.metamodelViewer.refresh();
        this.updateButtons((IStructuredSelection)this.metamodelViewer.getSelection());
    }

    private void updateButtons(IStructuredSelection selection) {
        boolean readOnly = this.getModelManager().getResourceManager().isReadOnly() || this.getModelManager().isLocal();
        this.addBtn.setEnabled(!readOnly);
        this.deleteBtn.setEnabled(!readOnly && !selection.isEmpty());
        this.viewBtn.setEnabled(selection.size() == 1 && !((EPackage)selection.getFirstElement()).eIsProxy());
    }
}

