/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.capella.common.helpers.export.DataExporter;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.core.validation.export.ExportMessages;
import org.polarsys.capella.core.validation.utils.ValidationHelper;

public class ExportUtils {
    private static final int COMPARATOR_IDX = 0;
    private static IConfigurationElement[] quickFixContributions = ExportUtils.getAllContributions();

    public static boolean exportValidationRules(DataExporter dataExporter_p, String filename_p) {
        boolean result = false;
        ArrayList<String[]> data = new ArrayList<String[]>();
        IEclipsePreferences preferences = new InstanceScope().getNode(CapellaValidationActivator.getDefault().getPluginId());
        boolean onlyActiveRules = preferences.getBoolean("validation.rules.export.active.only.exe", false);
        boolean onlyCapellaRules = preferences.getBoolean("validation.rules.export.capella.only.exe", false);
        boolean addit = false;
        for (IConstraintDescriptor icd : ValidationHelper.getAllConstraintDescriptors()) {
            boolean bl = addit = (!onlyActiveRules || onlyActiveRules && icd.isEnabled()) && (!onlyCapellaRules || onlyCapellaRules && ExportUtils.getCategory(icd).getPath().startsWith("capella.category"));
            if (!addit) continue;
            data.add(ExportUtils.prepareCSVTXT(icd));
        }
        Comparator<String[]> comparator = new Comparator<String[]>(){

            @Override
            public int compare(String[] o1_p, String[] o2_p) {
                return o1_p[0].compareTo(o2_p[0]);
            }
        };
        Collections.sort(data, comparator);
        String[] header = new String[]{ExportMessages.exportHeaderCategoryPath, ExportMessages.exportHeaderCategoryName, ExportMessages.exportHeaderRuleId, ExportMessages.exportHeaderRuleSeverity, ExportMessages.exportHeaderIsRuleEnabled, ExportMessages.exportHeaderRuleMode, ExportMessages.exportHeaderRuleDescription};
        data.add(0, header);
        result = dataExporter_p.exportToFile(filename_p, data);
        return result;
    }

    private static String[] prepareCSVTXT(IConstraintDescriptor icd_p) {
        Category category = ExportUtils.getCategory(icd_p);
        String[] result = new String[]{category.getPath(), category.getName(), icd_p.getId(), icd_p.getSeverity().getLocalizedName(), String.valueOf(icd_p.isEnabled()), icd_p.getEvaluationMode().getLocalizedName(), icd_p.getDescription()};
        return result;
    }

    private static IConfigurationElement[] getAllContributions() {
        String point = "org.polarsys.capella.core.validation.ui.ide.capellaQuickFix";
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(point);
        return configurationElements;
    }

    private static Category getCategory(IConstraintDescriptor icd_p) {
        return (Category)icd_p.getCategories().iterator().next();
    }
}

