/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacore.NamedElement;

public class DebugHelper {
    private DebugHelper() {
    }

    public static void displayTree(EObject root) {
        DebugHelper.displayTree(root, 0);
    }

    public static void displayTree(EObject root, int level) {
        if (root instanceof GenericTrace) {
            return;
        }
        EList elements = root.eContents();
        int i = 0;
        while (i < level) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(" + " + DebugHelper.elementToString(root));
        for (EObject element : elements) {
            DebugHelper.displayTree(element, level + 1);
        }
    }

    public static String elementToString(EObject object) {
        if (object == null) {
            return "";
        }
        if (object instanceof NamedElement) {
            if (object == object.eContainer()) {
                System.out.println("Object same container name " + object.toString());
            }
            return "'" + ((NamedElement)object).getName() + "' " + ((NamedElement)object).getFullLabel() + " [" + object.eClass().getName() + "] ";
        }
        return "Unnamed of [" + object.eClass().getName() + "] ";
    }

    public static String elementToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof EObject) {
            return DebugHelper.elementToString((EObject)obj);
        }
        if (obj instanceof List) {
            List lst = (List)obj;
            StringBuilder builder = new StringBuilder();
            for (Object object : lst) {
                builder.append(DebugHelper.elementToString(object));
            }
            return builder.toString();
        }
        return obj.toString();
    }
}

