/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.communication.SignalInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.ExecutionEvent;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.SequenceMessage;

public class NameGenerator {
    public static int __idAbstractEnd = 0;
    public static int __idInstanceRole = 0;
    public static int __idExecution = 0;
    public static int __idEvent = 0;

    private NameGenerator() {
    }

    public static void computeMessageEndName(MessageEnd messageEnd) {
        InstanceRole instanceRole = messageEnd.getCovered();
        assert (instanceRole != null);
        AbstractInstance instance = instanceRole.getRepresentedInstance();
        assert (instance != null);
        NamedElement component = null;
        if (instance instanceof Part) {
            component = (NamedElement)instance.eContainer();
        } else if (instance instanceof SignalInstance) {
            component = ((SignalInstance)instance).getType();
        }
        assert (component != null);
        String representedInstanceName = component.getName();
        SequenceMessage message = messageEnd.getMessage();
        String messageName = message.getName();
        boolean isSending = message.getSendingEnd() == messageEnd;
        messageEnd.setName("[[ " + (isSending ? "S" : "R") + " [" + representedInstanceName + "] " + messageName + "() " + "(Ref=" + __idAbstractEnd + ")" + " ]] ");
        ++__idAbstractEnd;
    }

    public static void computeExecutionEndName(ExecutionEnd executionEnd) {
        InstanceRole instanceRole = executionEnd.getCovered();
        AbstractInstance instance = instanceRole.getRepresentedInstance();
        NamedElement component = null;
        if (instance instanceof Part) {
            component = (NamedElement)instance.eContainer();
        } else if (instance instanceof SignalInstance) {
            component = ((SignalInstance)instance).getType();
        }
        assert (component != null);
        String representedInstanceName = component.getName();
        executionEnd.setName("[[ [" + representedInstanceName + "] " + "(Ref=" + __idAbstractEnd + ")" + " ]] ");
        ++__idAbstractEnd;
    }

    public static void computeInstanceRoleName(InstanceRole instanceRole) {
        AbstractInstance instance = instanceRole.getRepresentedInstance();
        NamedElement component = null;
        if (instance instanceof Part) {
            component = (NamedElement)instance.eContainer();
        } else if (instance instanceof SignalInstance) {
            component = ((SignalInstance)instance).getType();
        }
        assert (component != null);
        String componentName = component.getName();
        String representedInstanceName = component.getName();
        instanceRole.setName("[[ [" + representedInstanceName + " : " + componentName + "] " + "(Ref=" + __idInstanceRole + ")" + " ]] ");
        ++__idInstanceRole;
    }

    public static void computeExecutionName(Execution execution) {
        String roleName = ((AbstractEnd)execution.getStart()).getCovered().getName();
        execution.setName("Execution on " + roleName + "(Ref=" + __idExecution + ")");
        ++__idExecution;
    }

    public static void computeEventName(Event event) {
        boolean receive = event instanceof EventReceiptOperation;
        boolean send = event instanceof EventSentOperation;
        boolean execution = event instanceof ExecutionEvent;
        event.setName("Event " + (send ? "S" : "") + (receive ? "R" : "") + (execution ? "E" : "") + " (Ref=" + __idEvent + ")");
        ++__idEvent;
    }
}

