/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.helpers.modellingcore.utils.HoldingResourceFilter;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.tiger.IFinalizer;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoEngine;
import org.polarsys.capella.core.tiger.ITransfoRule;
import org.polarsys.capella.core.tiger.Messages;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.extension.ITransfoEngineExecuteExt;
import org.polarsys.capella.core.tiger.helpers.DebugHelper;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public abstract class TransfoEngine
extends ITransfoEngine {
    public static final String HOLDING_RESOURCE = "HOLDING_RESOURCE";
    public static final String __cr = System.getProperty("line.separator");
    public static final String TRANSFO_EXTENSION = "transfoExecuteExtension";
    public static final String BOOTSTRAP = "bootstrap";
    public static final String NEW_LINKS = "newLinks";
    public static final String TRANSFO_SOURCE = "transfoSource";
    public static final String TRANSFO_TARGET = "transfoTarget";
    public static final String TRANSFORMED_ELEMENTS = "transformedElements";
    protected List<EObject> _agenda;
    protected List<EObject> _dependingModels;
    protected Logger _logger = null;
    protected State _state = State.CREATED;
    protected ITransfo _transfo;
    protected List<EObject> _transformedElements;
    private String _transitionStartTemplate = "----- Perform transition of ''{0}'' -----";
    private String _alreadyTransitionedTemplate = "''{0}'' is already transitioned.";

    public TransfoEngine() {
        this(ReportManagerRegistry.getInstance().subscribe("Refinement"));
    }

    public TransfoEngine(Logger logger) {
        this._logger = logger;
        this._agenda = new ArrayList<EObject>();
        this._dependingModels = new ArrayList<EObject>();
        this._transformedElements = new ArrayList<EObject>();
    }

    private void attach() throws TransfoException {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)"Attach");
            this._logger.debug((Object)"====================================");
        }
        int step = 0;
        for (EObject sourceElement : this._agenda) {
            ITransfoRule rule;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)(" + Step " + step));
                this._logger.debug((Object)("   - Current element is : " + DebugHelper.elementToString(sourceElement)));
            }
            if ((rule = this._transfo.findCachedMatchingRule(sourceElement)) != null) {
                rule.attach(sourceElement, this._transfo);
            }
            ++step;
        }
    }

    private void check(ITransfo transfo) throws TransfoException {
        ArrayList<EObject> troubleList = new ArrayList<EObject>();
        for (EObject object : this._transformedElements) {
            if (object.eContainer() != null || !HoldingResourceFilter.getInstance().isHoldByHoldingResource(object) && object.eResource().getContents().contains((Object)object)) continue;
            troubleList.add(object);
        }
        if (troubleList.size() > 0) {
            StringBuilder builder = new StringBuilder("No containment for :");
            builder.append(System.getProperty("line.separator"));
            for (EObject troubleObject : troubleList) {
                builder.append(" - ");
                builder.append(DebugHelper.elementToString(troubleObject));
                builder.append(System.getProperty("line.separator"));
                CapellaElement element = (CapellaElement)troubleObject;
                TransfoEngine.cleanUp(element);
            }
            throw new TransfoException(builder.toString(), (EObject)transfo.get(TRANSFO_SOURCE));
        }
    }

    public abstract void doProcessDependingModels(List<EObject> var1) throws TransfoException;

    @Override
    public void execute(ITransfo transfo) throws TransfoException {
        try {
            try {
                this.preExecute(transfo);
                if (this._state != State.INITIALIZED) {
                    this.initialize(transfo);
                }
                this._state = State.RUNNING;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)"====================================");
                    this._logger.debug((Object)("Starting transformation '" + transfo.getUid() + "'"));
                    this._logger.debug((Object)"====================================");
                }
                this.processDependingModels();
                this.transformUpdate();
                this.attach();
                this.finalize_();
                List<IFinalizer> finalizers = this._transfo.getFinalizers();
                for (IFinalizer iFinalizer : finalizers) {
                    iFinalizer.finalize(transfo);
                }
                this.check(transfo);
                this._state = State.FINISH;
            }
            catch (OperationCanceledException exception) {
                String msg = exception.getMessage();
                this._logger.error((Object)msg, (Throwable)exception);
                throw exception;
            }
            catch (TransfoException exception) {
                exception.printStackTrace();
                String msg = NLS.bind((String)Messages.TransfoEngine_ErrorWhileTransformation, (Object)exception.getMessage());
                this._logger.error((Object)msg, (Throwable)exception);
                throw exception;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String msg = NLS.bind((String)(String.valueOf(Messages.TransfoEngine_ErrorWhileTransformationDetailled) + exception.getMessage()), (Object)exception.getClass().getSimpleName());
                this._logger.error((Object)msg, (Throwable)exception);
                throw new TransfoException(String.valueOf(exception.getMessage()) + "(" + exception.getClass().getSimpleName() + ")", this._transfo != null ? (EObject)this._transfo.get(TRANSFO_SOURCE) : null, exception);
            }
        }
        finally {
            this.postExecute(transfo);
        }
    }

    public void preExecute(ITransfo transfo) throws CoreException, Exception {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.polarsys.capella.core.tiger");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (TRANSFO_EXTENSION.equals(element.getName())) {
                ITransfoEngineExecuteExt extension = (ITransfoEngineExecuteExt)element.createExecutableExtension("class");
                extension.preExecute(transfo);
            }
            ++n2;
        }
    }

    public void postExecute(ITransfo transfo) {
        try {
            IConfigurationElement[] elements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.polarsys.capella.core.tiger");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (TRANSFO_EXTENSION.equals(element.getName())) {
                    ITransfoEngineExecuteExt extension = (ITransfoEngineExecuteExt)element.createExecutableExtension("class");
                    extension.postExecute(transfo);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String msg = NLS.bind((String)(String.valueOf(Messages.TransfoEngine_ErrorWhileTransformationDetailled) + exception.getMessage()), (Object)exception.getClass().getSimpleName());
            this._logger.error((Object)msg, (Throwable)exception);
        }
    }

    protected abstract void finalize_();

    @Override
    public String generateReport() {
        StringBuilder builder = new StringBuilder();
        if (this._state == State.INITIALIZED) {
            builder.append("The transformation " + this._transfo.getUid() + " is about to be launched.");
            builder.append(__cr);
            builder.append("It requires " + this._agenda.size() + " transformations.");
            builder.append(__cr);
        } else if (this._state == State.FINISH) {
            builder.append(String.valueOf(this._agenda.size()) + " transformations has been done.");
            builder.append(__cr);
        }
        return builder.toString();
    }

    @Override
    public void generateUid() {
    }

    public List<EObject> getAgenda() {
        return this._agenda;
    }

    @Override
    public String getName() {
        return "Tiger";
    }

    protected String getReportComponent() {
        return "Refinement";
    }

    protected void initialize() {
        this._agenda.clear();
        this._dependingModels.clear();
        ArrayList links = new ArrayList();
        this._transfo.put(NEW_LINKS, links);
        this._transfo.put(TRANSFORMED_ELEMENTS, this._transformedElements);
        this.initialize_();
    }

    @Override
    public void initialize(ITransfo transfo) throws TransfoException {
        this._state = State.CREATED;
        this.setTransfo(transfo);
        this.generateUid();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)("Initializing transformation '" + transfo.getUid() + "'"));
            this._logger.debug((Object)"====================================");
        }
        this.initialize();
        this.retrieveElements();
        this.retrieveDependingModels();
        this._state = State.INITIALIZED;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)"Report");
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)this.generateReport());
        }
    }

    protected abstract void initialize_();

    private void processDependingModels() throws TransfoException {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)"Process depending models");
            this._logger.debug((Object)"====================================");
        }
        this.doProcessDependingModels(this._dependingModels);
    }

    private void registerTargetElement(EObject sourceElement, EObject targetElement) throws TransfoException {
        if (targetElement != null) {
            if (targetElement.eResource() == null) {
                HoldingResourceHelper.attachToHoldingResource((EObject)targetElement, (Resource)this.getHoldingResource(this._transfo));
            }
            this._transformedElements.add(targetElement);
            AbstractTrace newLink = TigerRelationshipHelper.createTransfoLink(sourceElement, targetElement, this._transfo);
            if (newLink != null) {
                if (newLink.eContainer() == null) {
                    HoldingResourceHelper.attachToHoldingResource((EObject)newLink, (Resource)this.getHoldingResource(this._transfo));
                }
                List links = (List)this._transfo.get(NEW_LINKS);
                links.add(newLink);
            }
        }
    }

    private void retrieveDependingModels() {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)"Retrieving depending models");
            this._logger.debug((Object)"====================================");
        }
        this._dependingModels.clear();
        for (EObject element : this._agenda) {
            ModelRoot object = Query.retrieveModelRoot(element);
            if (this._dependingModels.contains(object)) continue;
            this._dependingModels.add((EObject)object);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)(String.valueOf(this._dependingModels.size()) + " depending models had been detected."));
        }
    }

    protected void retrieveElements() throws TransfoException {
        String startMessage;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)"Retrieving elements to be transformed");
            this._logger.debug((Object)"====================================");
        }
        LinkedList<EObject> agenda = new LinkedList<EObject>();
        HashSet<EObject> visited = new HashSet<EObject>();
        List bootstrap = (List)this._transfo.get(BOOTSTRAP);
        agenda.addAll(bootstrap);
        if (!agenda.isEmpty() && this._logger.isInfoEnabled() && (startMessage = this.formatTransitionStartMessage((EObject)agenda.get(0))) != null) {
            this._logger.info((Object)new EmbeddedMessage(startMessage, this._logger.getName(), agenda.get(0)));
        }
        int step = 0;
        while (!agenda.isEmpty()) {
            EObject currentElement = (EObject)agenda.removeFirst();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)(" + Step " + step));
                this._logger.debug((Object)("   - The agenda size is : " + agenda.size()));
                this._logger.debug((Object)("   - The current element is : " + DebugHelper.elementToString(currentElement)));
            }
            if (currentElement == null) {
                throw new TransfoException("The parsed element is 'null'", currentElement);
            }
            if (visited.contains(currentElement)) continue;
            visited.add(currentElement);
            this._agenda.add(currentElement);
            ITransfoRule rule = this._transfo.findCachedMatchingRule(currentElement);
            if (rule == null) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("      -> Warning no rule found for " + DebugHelper.elementToString(currentElement)));
                }
                agenda.remove(currentElement);
            } else {
                List<EObject> relatedElements;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("   - Matching rule is : " + rule.getName()));
                }
                if ((relatedElements = rule.retrieveRelatedElements(currentElement, this._transfo)) != null && relatedElements.contains(null)) {
                    throw new TransfoException("One related element is 'null'", currentElement, rule);
                }
                if (relatedElements != null) {
                    agenda.addAll(relatedElements);
                    if (this._logger.isDebugEnabled()) {
                        for (EObject relatedElement : relatedElements) {
                            this._logger.debug((Object)("   - Re-injecting element : " + DebugHelper.elementToString(relatedElement)));
                        }
                    }
                }
            }
            ++step;
        }
    }

    @Override
    public void run() {
        try {
            this.execute(this._transfo);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println(this.generateReport());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTransfo(ITransfo transfo) {
        this._transfo = transfo;
    }

    protected Resource getHoldingResource(ITransfo transfo) {
        if (!transfo.containsKey(HOLDING_RESOURCE)) {
            EObject transfoSource = (EObject)this._transfo.get(TRANSFO_SOURCE);
            transfo.put(HOLDING_RESOURCE, HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)transfoSource)));
        }
        return (Resource)transfo.get(HOLDING_RESOURCE);
    }

    private void transformUpdate() throws TransfoException {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)"Transform/Update");
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)("Nb of element to be transformed: " + this._agenda.size()));
        }
        int step = 0;
        for (EObject sourceElement : this._agenda) {
            ITransfoRule rule;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)(" + Step " + step));
                this._logger.debug((Object)("   - Current element is : " + DebugHelper.elementToString(sourceElement)));
            }
            if ((rule = this._transfo.findCachedMatchingRule(sourceElement)) != null) {
                if (rule.requireTransformation(sourceElement, this._transfo)) {
                    Object elements = rule.transform(sourceElement, this._transfo);
                    if (elements instanceof Collection) {
                        Collection objects = (Collection)elements;
                        for (EObject targetElement : objects) {
                            this.registerTargetElement(sourceElement, targetElement);
                        }
                    } else {
                        EObject targetElement = (EObject)elements;
                        this.registerTargetElement(sourceElement, targetElement);
                    }
                } else {
                    String alreadyTransitionedMessage;
                    Object transformedElement = Query.retrieveTransformedElement(sourceElement, this._transfo);
                    if (this._logger.isInfoEnabled() && (alreadyTransitionedMessage = this.formatAlreadyTransitionedMessage(sourceElement, transformedElement)) != null) {
                        this._logger.info((Object)new EmbeddedMessage(alreadyTransitionedMessage, this._logger.getName(), (Object)new Object[]{sourceElement, transformedElement}));
                    }
                }
                rule.update(sourceElement, this._transfo);
            }
            ++step;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    private static void cleanUp(CapellaElement element) {
        ArrayList traces = new ArrayList(element.getIncomingTraces());
        for (AbstractTrace trace : traces) {
            trace.destroy();
        }
        traces = new ArrayList(element.getOutgoingTraces());
        for (AbstractTrace trace : traces) {
            trace.destroy();
        }
        element.destroy();
    }

    public void setTransitionStartTemplate(String template) {
        this._transitionStartTemplate = template;
    }

    public void setAlreadyTransitionedTemplate(String template) {
        this._alreadyTransitionedTemplate = template;
    }

    private String formatTransitionStartMessage(EObject first) {
        String result = null;
        if (this._transitionStartTemplate != null) {
            result = NLS.bind((String)this._transitionStartTemplate, (Object)EObjectLabelProviderHelper.getText((EObject)first));
        }
        return result;
    }

    private String formatAlreadyTransitionedMessage(EObject transitioned, Object transformedElement) {
        String result = null;
        if (this._alreadyTransitionedTemplate != null) {
            result = NLS.bind((String)this._alreadyTransitionedTemplate, (Object)EObjectLabelProviderHelper.getText((EObject)transitioned), (Object)EObjectLabelProviderHelper.getText((Object)transformedElement));
        }
        return result;
    }

    public static enum State {
        CREATED,
        FINISH,
        INITIALIZED,
        RUNNING;

    }
}

