/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyControl;

public class PropertyWizardPage
extends WizardPage
implements PropertyChangeListener {
    protected IPropertyContext context;
    protected IRendererContext renderers;
    protected IStatus lastStatus;
    protected IProperty lastProperty;

    protected IPropertyContext getContext() {
        return this.context;
    }

    protected IRendererContext getRendererContext() {
        return this.renderers;
    }

    public PropertyWizardPage(String pageName, IPropertyContext context, IRendererContext renderers) {
        super(pageName);
        this.context = context;
        this.renderers = renderers;
        IPropertyContext ctx = this.getContext();
        ctx.registerListener((PropertyChangeListener)this);
        this.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor("dialog_title_banner_image"));
    }

    public void dispose() {
        try {
            for (IProperty property : this.getContext().getProperties().getAllItems()) {
                IPropertyRenderer renderer = this.getRendererContext().getRenderer(property);
                if (renderer == null) continue;
                try {
                    renderer.dispose(this.getRendererContext());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose();
    }

    protected ILabelProvider getLabelProvider() {
        return this.getRendererContext().getLabelProvider();
    }

    public void createControl(Composite parent) {
        ILabelProvider labelProvider = this.getLabelProvider();
        PropertyControl control = new PropertyControl(labelProvider, this.getContext(), this.getRendererContext());
        this.setControl(control.createControl(parent));
        this.update(null);
    }

    protected void applyToStatusLine() {
        if (this.lastStatus != null) {
            String message = this.lastStatus.getMessage();
            if (message == null || message.length() == 0) {
                this.setErrorMessage(null);
                this.setMessage(this.getDescription());
            } else {
                switch (this.lastStatus.getSeverity()) {
                    case 0: {
                        this.setErrorMessage(null);
                        this.setMessage(this.getDescription());
                        break;
                    }
                    case 2: {
                        this.setErrorMessage(null);
                        this.setMessage(message, 2);
                        break;
                    }
                    case 1: {
                        this.setErrorMessage(null);
                        this.setMessage(message, 1);
                        break;
                    }
                    default: {
                        this.setErrorMessage(null);
                        this.setMessage(message, 3);
                    }
                }
            }
        }
    }

    public boolean isPageComplete() {
        if (this.lastStatus == null) {
            return true;
        }
        boolean isError = this.lastStatus.matches(4);
        return !isError;
    }

    protected void findMostSevere() {
        IProperties properties;
        IPropertyContext context = this.getContext();
        int level = 0;
        this.lastStatus = Status.OK_STATUS;
        this.lastProperty = null;
        if (context != null && (properties = context.getProperties()) != null) {
            for (IProperty item : properties.getAllItems()) {
                IStatus status = item.validate(context.getCurrentValue(item), context);
                if (status == null || status.isOK() || level >= status.getSeverity()) continue;
                level = status.getSeverity();
                this.lastStatus = status;
                this.lastProperty = item;
            }
        }
    }

    public void update(PropertyChangedEvent event) {
        this.findMostSevere();
        this.applyToStatusLine();
        this.setPageComplete(this.isPageComplete());
    }
}

