/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.AbstractMarkerViewContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.CanonicalContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.CategoryContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.Messages;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.PreferenceRuleSetLabelProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.RuleIdContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.SeverityContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.SeverityLevel;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;

class MarkerViewColumns {
    private TreeViewer viewer;
    private List<TreeViewerColumn> columns;
    private Class<?> providerClass;
    private Map<Class<?>, Runnable> columnFactories;
    private Map<ColumnLabelProvider, Integer> comparatorDirections;
    private SelectionListener listener;
    final String key = "markerviewcolumns.sorter";
    private ColumnLabelProvider messageLabelProvider;
    private ColumnLabelProvider ruleIDLabelProvider;
    private ColumnLabelProvider preferenceReulSetLabelProvider;
    private ColumnLabelProvider originLabelProvider;
    private ColumnLabelProvider timeLabelProvider;
    private ColumnLabelProvider resourceLabelProvider;
    private ColumnLabelProvider severityLabelProvider;

    public MarkerViewColumns(TreeViewer viewer) {
        this.viewer = viewer;
        this.listener = this.createSelectionListener();
        this.comparatorDirections = new HashMap<ColumnLabelProvider, Integer>();
        this.columns = new ArrayList<TreeViewerColumn>();
        this.columnFactories = new HashMap();
        this.columnFactories.put(RuleIdContentProvider.class, new Runnable(){

            @Override
            public void run() {
                MarkerViewColumns.this.createMessageColumn();
                MarkerViewColumns.this.createSeverityColumn();
                MarkerViewColumns.this.createRuleIdColumn();
                MarkerViewColumns.this.createPreferencesRuleSetColumn();
                MarkerViewColumns.this.createOriginColumn();
                MarkerViewColumns.this.createResourceColumn();
                MarkerViewColumns.this.createTimeColumn();
                MarkerViewColumns.this.restoreComparator();
            }
        });
        this.columnFactories.put(PreferenceRuleSetLabelProvider.class, new Runnable(){

            @Override
            public void run() {
                MarkerViewColumns.this.createMessageColumn();
                MarkerViewColumns.this.createSeverityColumn();
                MarkerViewColumns.this.createRuleIdColumn();
                MarkerViewColumns.this.createPreferencesRuleSetColumn();
                MarkerViewColumns.this.createOriginColumn();
                MarkerViewColumns.this.createResourceColumn();
                MarkerViewColumns.this.createTimeColumn();
                MarkerViewColumns.this.restoreComparator();
            }
        });
        this.columnFactories.put(SeverityContentProvider.class, new Runnable(){

            @Override
            public void run() {
                MarkerViewColumns.this.createMessageColumn();
                MarkerViewColumns.this.createSeverityColumn();
                MarkerViewColumns.this.createRuleIdColumn();
                MarkerViewColumns.this.createPreferencesRuleSetColumn();
                MarkerViewColumns.this.createOriginColumn();
                MarkerViewColumns.this.createResourceColumn();
                MarkerViewColumns.this.createTimeColumn();
                MarkerViewColumns.this.restoreComparator();
            }
        });
        this.columnFactories.put(CanonicalContentProvider.class, new Runnable(){

            @Override
            public void run() {
                MarkerViewColumns.this.createMessageColumn();
                MarkerViewColumns.this.createSeverityColumn();
                MarkerViewColumns.this.createRuleIdColumn();
                MarkerViewColumns.this.createPreferencesRuleSetColumn();
                MarkerViewColumns.this.createOriginColumn();
                MarkerViewColumns.this.createResourceColumn();
                MarkerViewColumns.this.createTimeColumn();
                MarkerViewColumns.this.restoreComparator();
            }
        });
        this.columnFactories.put(CategoryContentProvider.class, new Runnable(){

            @Override
            public void run() {
                MarkerViewColumns.this.createMessageColumn();
                MarkerViewColumns.this.createSeverityColumn();
                MarkerViewColumns.this.createRuleIdColumn();
                MarkerViewColumns.this.createPreferencesRuleSetColumn();
                MarkerViewColumns.this.createOriginColumn();
                MarkerViewColumns.this.createResourceColumn();
                MarkerViewColumns.this.createTimeColumn();
                MarkerViewColumns.this.restoreComparator();
            }
        });
    }

    private void restoreComparator() {
        LabelProviderComparator comparator = (LabelProviderComparator)this.viewer.getComparator();
        if (comparator != null) {
            TreeViewerColumn column;
            ColumnLabelProvider provider;
            ColumnLabelProvider active = comparator.getProvider();
            Iterator<TreeViewerColumn> iterator = this.columns.iterator();
            if (iterator.hasNext() && (provider = (ColumnLabelProvider)(column = iterator.next()).getColumn().getData("markerviewcolumns.sorter")) == active) {
                this.viewer.getTree().setSortColumn(column.getColumn());
                this.viewer.getTree().setSortDirection(this.viewer.getTree().getSortDirection());
            }
        } else {
            comparator = new LabelProviderComparator((ColumnLabelProvider)this.columns.get(0).getColumn().getData("markerviewcolumns.sorter"), 1024);
            this.viewer.setComparator((ViewerComparator)comparator);
            this.viewer.getTree().setSortColumn(this.columns.get(0).getColumn());
            this.viewer.getTree().setSortDirection(1024);
        }
    }

    private SelectionListener createSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnLabelProvider provider = (ColumnLabelProvider)event.widget.getData("markerviewcolumns.sorter");
                LabelProviderComparator comparator = (LabelProviderComparator)MarkerViewColumns.this.viewer.getComparator();
                if (comparator.getProvider() == provider) {
                    comparator.flip();
                } else {
                    comparator.setProvider(provider);
                    Integer direction = (Integer)MarkerViewColumns.this.comparatorDirections.get(provider);
                    if (direction == null) {
                        direction = 1024;
                    }
                    comparator.setDirection(direction);
                }
                MarkerViewColumns.this.comparatorDirections.put(provider, comparator.getDirection());
                MarkerViewColumns.this.viewer.getTree().setSortColumn((TreeColumn)event.widget);
                MarkerViewColumns.this.viewer.getTree().setSortDirection(comparator.getDirection());
                MarkerViewColumns.this.viewer.refresh();
            }
        };
    }

    void update(AbstractMarkerViewContentProvider provider) {
        Class<?> providerClass = provider.getClass();
        if (providerClass != this.providerClass) {
            this.disposeAll();
            for (Class<?> c : this.columnFactories.keySet()) {
                if (!c.isAssignableFrom(providerClass)) continue;
                this.columnFactories.get(providerClass).run();
            }
            this.providerClass = provider.getClass();
        }
    }

    void disposeAll() {
        Iterator<TreeViewerColumn> it = this.columns.iterator();
        while (it.hasNext()) {
            TreeViewerColumn column = it.next();
            it.remove();
            column.getColumn().dispose();
        }
    }

    private void createMessageColumn() {
        TreeViewerColumn cMessage = new TreeViewerColumn(this.viewer, 0);
        cMessage.getColumn().setWidth(500);
        cMessage.getColumn().setMoveable(true);
        cMessage.getColumn().setText(Messages.MarkerView_Column_Title_Message);
        ColumnLabelProvider provider = this.getMessageLabelProvider();
        cMessage.setLabelProvider((CellLabelProvider)provider);
        cMessage.getColumn().setData("markerviewcolumns.sorter", (Object)provider);
        cMessage.getColumn().addSelectionListener(this.listener);
        this.columns.add(cMessage);
    }

    private void createSeverityColumn() {
        TreeViewerColumn cSeverity = new TreeViewerColumn(this.viewer, 0);
        cSeverity.getColumn().setWidth(80);
        cSeverity.getColumn().setMoveable(true);
        cSeverity.getColumn().setText(Messages.MarkerView_Column_Title_Level);
        ColumnLabelProvider provider = this.getSeverityLabelProvider();
        cSeverity.setLabelProvider((CellLabelProvider)provider);
        cSeverity.getColumn().setData("markerviewcolumns.sorter", (Object)provider);
        cSeverity.getColumn().addSelectionListener(this.listener);
        this.columns.add(cSeverity);
    }

    private void createTimeColumn() {
        TreeViewerColumn cTime = new TreeViewerColumn(this.viewer, 0);
        cTime.getColumn().setWidth(80);
        cTime.getColumn().setMoveable(true);
        cTime.getColumn().setText(Messages.MarkerView_Column_Title_Time);
        ColumnLabelProvider provider = this.getTimeLabelProvider();
        cTime.setLabelProvider((CellLabelProvider)provider);
        cTime.getColumn().setData("markerviewcolumns.sorter", (Object)provider);
        cTime.getColumn().addSelectionListener(this.listener);
        this.columns.add(cTime);
    }

    private void createResourceColumn() {
        TreeViewerColumn cResource = new TreeViewerColumn(this.viewer, 0);
        cResource.getColumn().setWidth(120);
        cResource.getColumn().setMoveable(true);
        cResource.getColumn().setText(Messages.MarkerView_Column_Title_Resource);
        ColumnLabelProvider provider = this.getResourceLabelProvider();
        cResource.setLabelProvider((CellLabelProvider)provider);
        cResource.getColumn().setData("markerviewcolumns.sorter", (Object)provider);
        cResource.getColumn().addSelectionListener(this.listener);
        this.columns.add(cResource);
    }

    private void createRuleIdColumn() {
        TreeViewerColumn cRule = new TreeViewerColumn(this.viewer, 0);
        cRule.getColumn().setWidth(80);
        cRule.getColumn().setMoveable(true);
        cRule.getColumn().setText(Messages.MarkerView_Column_Title_RuleId);
        ColumnLabelProvider provider = this.getRuleIDLabelProvider();
        cRule.setLabelProvider((CellLabelProvider)provider);
        cRule.getColumn().setData("markerviewcolumns.sorter", (Object)provider);
        cRule.getColumn().addSelectionListener(this.listener);
        this.columns.add(cRule);
    }

    private void createPreferencesRuleSetColumn() {
        TreeViewerColumn preferenceRuleSetName = new TreeViewerColumn(this.viewer, 0);
        preferenceRuleSetName.getColumn().setWidth(120);
        preferenceRuleSetName.getColumn().setMoveable(true);
        preferenceRuleSetName.getColumn().setText(Messages.MarkerView_Column_Title_RuleSetId);
        ColumnLabelProvider provider = this.getPreferenceRuleSetLabelProvider();
        preferenceRuleSetName.setLabelProvider((CellLabelProvider)provider);
        preferenceRuleSetName.getColumn().setData("markerviewcolumns.sorter", (Object)provider);
        preferenceRuleSetName.getColumn().addSelectionListener(this.listener);
        this.columns.add(preferenceRuleSetName);
    }

    private void createOriginColumn() {
        TreeViewerColumn cOrigin = new TreeViewerColumn(this.viewer, 0);
        cOrigin.getColumn().setWidth(200);
        cOrigin.getColumn().setMoveable(true);
        cOrigin.getColumn().setText(Messages.MarkerView_Column_Title_Origin);
        ColumnLabelProvider provider = this.getCategoryLabelProvider();
        cOrigin.setLabelProvider((CellLabelProvider)provider);
        cOrigin.getColumn().setData("markerviewcolumns.sorter", (Object)provider);
        cOrigin.getColumn().addSelectionListener(this.listener);
        this.columns.add(cOrigin);
    }

    private ColumnLabelProvider getResourceLabelProvider() {
        if (this.resourceLabelProvider == null) {
            this.resourceLabelProvider = new MarkerViewColumnLabelProvider(){

                public String getText(Object element) {
                    String result = "";
                    if (element instanceof IMarker) {
                        result = ((IMarker)element).getAttribute("org.eclipse.ui.views.markers.path", "");
                    }
                    return result;
                }
            };
        }
        return this.resourceLabelProvider;
    }

    private ColumnLabelProvider getTimeLabelProvider() {
        if (this.timeLabelProvider == null) {
            this.timeLabelProvider = new MarkerViewColumnLabelProvider(){
                final DateFormat format;
                {
                    this.format = DateFormat.getTimeInstance();
                }

                public String getText(Object element) {
                    String result = "";
                    if (element instanceof IMarker) {
                        try {
                            result = this.format.format(new Date(((IMarker)element).getCreationTime()));
                        }
                        catch (CoreException e) {
                            MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getLocalizedMessage(), (Throwable)e));
                        }
                    }
                    return result;
                }
            };
        }
        return this.timeLabelProvider;
    }

    private ColumnLabelProvider getMessageLabelProvider() {
        if (this.messageLabelProvider == null) {
            this.messageLabelProvider = new MarkerViewColumnLabelProvider(){
                Pattern pattern;
                {
                    this.pattern = Pattern.compile("(\\r|\\n)");
                }

                private int countMarkerChildren(Object element) {
                    ITreeContentProvider provider = (ITreeContentProvider)MarkerViewColumns.this.viewer.getContentProvider();
                    int markerChildren = 0;
                    Object[] children = provider.getChildren(element);
                    if (children != null) {
                        Object[] objectArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object c = objectArray[n2];
                            if (c instanceof IMarker) {
                                boolean selected = true;
                                ViewerFilter[] viewerFilterArray = MarkerViewColumns.this.viewer.getFilters();
                                int n3 = viewerFilterArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ViewerFilter filter = viewerFilterArray[n4];
                                    if (!filter.select((Viewer)MarkerViewColumns.this.viewer, element, c)) {
                                        selected = false;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (selected) {
                                    ++markerChildren;
                                }
                            } else {
                                markerChildren += this.countMarkerChildren(c);
                            }
                            ++n2;
                        }
                    }
                    return markerChildren;
                }

                public String getText(Object element) {
                    String result = element.toString();
                    if (element == MarkerViewHelper.OTHER_CATEGORY || element == MarkerViewHelper.OTHER_RULES) {
                        result = Messages.MarkerLabelProvider_EcoreDiagnosticSourceLabel;
                    }
                    if (element instanceof IMarker) {
                        result = ((IMarker)element).getAttribute("message", "").toString();
                        result = this.pattern.matcher(result).replaceAll(" ");
                    } else if (element instanceof IConstraintDescriptor) {
                        result = ((IConstraintDescriptor)element).getName();
                    } else if (element instanceof Category) {
                        result = ((Category)element).getName();
                    }
                    int markerChildren = this.countMarkerChildren(element);
                    if (markerChildren == 1) {
                        result = String.valueOf(result) + " (1 item)";
                    } else if (markerChildren > 1) {
                        result = String.valueOf(result) + " (" + markerChildren + " items)";
                    }
                    return result;
                }

                public Image getImage(Object element) {
                    if (element instanceof IMarker) {
                        IMarker marker = (IMarker)element;
                        List<EObject> elements = MarkerViewHelper.getModelElementsFromMarker(marker);
                        if (elements.size() > 0) {
                            return EObjectLabelProviderHelper.getImage((EObject)elements.get(0));
                        }
                    } else {
                        if (element instanceof SeverityLevel) {
                            return ((SeverityLevel)((Object)element)).getImage();
                        }
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        ISharedImages images = workbench.getSharedImages();
                        return images.getImage("IMG_OBJ_FOLDER");
                    }
                    return null;
                }

                @Override
                public String getToolTipText(Object element) {
                    String result = null;
                    result = element instanceof IMarker ? ((IMarker)element).getAttribute("message", "") : super.getToolTipText(element);
                    return result;
                }
            };
        }
        return this.messageLabelProvider;
    }

    private ColumnLabelProvider getRuleIDLabelProvider() {
        if (this.ruleIDLabelProvider == null) {
            this.ruleIDLabelProvider = new MarkerViewColumnLabelProvider(){

                public String getText(Object element) {
                    String result = "";
                    if (element instanceof IMarker && (result = MarkerViewHelper.getRuleID((IMarker)element, false)) == null && (result = MarkerViewHelper.getSource((IMarker)element)) != null && result.equals("org.eclipse.emf.ecore")) {
                        result = Messages.MarkerLabelProvider_EcoreDiagnosticSourceLabel;
                    }
                    return result;
                }

                public Image getImage(Object element) {
                    if (element instanceof IMarker) {
                        IMarker marker = (IMarker)element;
                        IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
                        if (resolutions != null && resolutions.length > 0) {
                            if (this.hasAtLeastOneMultipleMarkerResolution(marker, resolutions)) {
                                return MarkerViewPlugin.getDefault().getImage("quickfixAll-repository.png");
                            }
                            return MarkerViewPlugin.getDefault().getImage("quickfix.gif");
                        }
                    }
                    return null;
                }

                private boolean hasAtLeastOneMultipleMarkerResolution(IMarker marker, IMarkerResolution[] resolutions) {
                    Collection<IMarker> allMarkers = LightMarkerRegistry.getInstance().getMarkers();
                    ArrayList<IMarker> sameConstraintMarkers = new ArrayList<IMarker>();
                    IConstraintDescriptor markerDesc = MarkerViewHelper.getConstraintDescriptor(marker);
                    for (IMarker m : allMarkers) {
                        if (MarkerViewHelper.getConstraintDescriptor(m) != markerDesc) continue;
                        sameConstraintMarkers.add(m);
                    }
                    IMarkerResolution[] iMarkerResolutionArray = resolutions;
                    int n = resolutions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker[] similarMarkers;
                        IMarkerResolution res = iMarkerResolutionArray[n2];
                        if (res instanceof WorkbenchMarkerResolution && (similarMarkers = ((WorkbenchMarkerResolution)res).findOtherMarkers(sameConstraintMarkers.toArray(new IMarker[0]))).length > 1) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            };
        }
        return this.ruleIDLabelProvider;
    }

    public ColumnLabelProvider getPreferenceRuleSetLabelProvider() {
        if (this.preferenceReulSetLabelProvider == null) {
            this.preferenceReulSetLabelProvider = new MarkerViewColumnLabelProvider(){

                public String getText(Object element) {
                    String result = "";
                    if (element instanceof IMarker && (result = MarkerViewHelper.getPreferenceFileName((IMarker)element)) != null && !result.isEmpty()) {
                        return result;
                    }
                    return result;
                }

                public Image getImage(Object element) {
                    Image result = null;
                    return result;
                }
            };
        }
        return this.preferenceReulSetLabelProvider;
    }

    private ColumnLabelProvider getSeverityLabelProvider() {
        if (this.severityLabelProvider == null) {
            this.severityLabelProvider = new MarkerViewColumnLabelProvider(){

                public String getText(Object element) {
                    SeverityLevel level;
                    String result = "";
                    if (element instanceof IMarker && (level = SeverityLevel.getLevel((IMarker)element)) != null) {
                        result = level.toString();
                    }
                    return result;
                }

                public Image getImage(Object element) {
                    SeverityLevel level;
                    Image result = null;
                    if (element instanceof IMarker && (level = SeverityLevel.getLevel((IMarker)element)) != null) {
                        result = level.getImage();
                    }
                    return result;
                }
            };
        }
        return this.severityLabelProvider;
    }

    private ColumnLabelProvider getCategoryLabelProvider() {
        if (this.originLabelProvider == null) {
            this.originLabelProvider = new MarkerViewColumnLabelProvider(){

                public String getText(Object element) {
                    String result = "";
                    if (element instanceof IMarker) {
                        Diagnostic diagnostic = MarkerViewHelper.getDiagnostic((IMarker)element);
                        if (diagnostic instanceof ConstraintStatusDiagnostic) {
                            Set cats = ((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus().getConstraint().getDescriptor().getCategories();
                            if (!cats.isEmpty()) {
                                result = ((Category)cats.iterator().next()).getQualifiedName();
                            }
                        } else {
                            result = MarkerViewHelper.getSource((IMarker)element);
                            if (result != null && result.equals("org.eclipse.emf.ecore")) {
                                result = Messages.MarkerLabelProvider_EcoreDiagnosticSourceLabel;
                            }
                        }
                    }
                    return result;
                }
            };
        }
        return this.originLabelProvider;
    }

    class LabelProviderComparator
    extends ViewerComparator {
        private ColumnLabelProvider provider;
        private int direction;

        LabelProviderComparator(ColumnLabelProvider provider, int direction) {
            this.provider = provider;
            this.direction = direction;
        }

        public int category(Object o) {
            if (o instanceof IMarker) {
                return 100;
            }
            return 0;
        }

        public void flip() {
            this.direction = this.direction == 128 ? 1024 : 128;
        }

        void setDirection(int direction) {
            this.direction = direction;
        }

        int getDirection() {
            return this.direction;
        }

        void setProvider(ColumnLabelProvider provider) {
            this.provider = provider;
        }

        ColumnLabelProvider getProvider() {
            return this.provider;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            int cat2;
            int cat1 = this.category(o1);
            if (cat1 != (cat2 = this.category(o2))) {
                return cat1 - cat2;
            }
            if (o1 instanceof IMarker && o2 instanceof IMarker) {
                String t1 = this.provider.getText(o1);
                String t2 = this.provider.getText(o2);
                if (t1 == null) {
                    t1 = "";
                }
                if (t2 == null) {
                    t2 = "";
                }
                int flip = 1;
                if (this.direction == 128) {
                    flip = -1;
                }
                return flip * t1.compareTo(t2);
            }
            if (o1 instanceof SeverityLevel && o2 instanceof SeverityLevel) {
                SeverityLevel l1 = (SeverityLevel)((Object)o1);
                SeverityLevel l2 = (SeverityLevel)((Object)o2);
                return -1 * l1.compareTo(l2);
            }
            if (o1 instanceof Category && o2 instanceof Category) {
                Category c1 = (Category)o1;
                Category c2 = (Category)o2;
                return c1.getName().compareTo(c2.getName());
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    class MarkerViewColumnLabelProvider
    extends ColumnLabelProvider {
        MarkerViewColumnLabelProvider() {
        }

        public String getToolTipText(Object element) {
            String result = null;
            if (element instanceof IConstraintDescriptor) {
                result = ((IConstraintDescriptor)element).getDescription();
            } else if (element instanceof IMarker) {
                IConstraintDescriptor descriptor = MarkerViewHelper.getConstraintDescriptor((IMarker)element);
                if (descriptor != null) {
                    result = descriptor.getDescription();
                }
            } else if (element instanceof Category) {
                result = ((Category)element).getDescription();
            }
            return result;
        }
    }
}

