/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.commands;

import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.refinement.processor.InterfaceDelegationSCtoLC;

public class GenerateInterfaceDelegationsCommand
extends AbstractReadWriteCommand {
    private ModelElement modelElement = null;

    public GenerateInterfaceDelegationsCommand(ModelElement modelElement) {
        this.modelElement = modelElement;
    }

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            if (this.modelElement instanceof LogicalComponent) {
                new InterfaceDelegationSCtoLC((LogicalComponent)this.modelElement).perform();
            } else if (this.modelElement instanceof LogicalActor) {
                new InterfaceDelegationSCtoLC((LogicalActor)this.modelElement).perform();
            } else if (this.modelElement instanceof LogicalActorPkg) {
                new InterfaceDelegationSCtoLC((LogicalActorPkg)this.modelElement).perform();
            } else if (this.modelElement instanceof System) {
                new InterfaceDelegationSCtoLC((System)this.modelElement).perform();
            } else if (this.modelElement instanceof Actor) {
                new InterfaceDelegationSCtoLC((Actor)this.modelElement).perform();
            } else if (this.modelElement instanceof ActorPkg) {
                new InterfaceDelegationSCtoLC((ActorPkg)this.modelElement).perform();
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
    }

    public String getName() {
        return "Generate Interface Delegations";
    }
}

