/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.commands;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.refinement.RefinementMultiple;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;

public class ScenarioRefinementCommand
extends AbstractReadWriteCommand {
    private ModelElement selectedElement = null;
    private IProgressMonitor progressMonitor = null;
    private Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");

    public ScenarioRefinementCommand(ModelElement modelElement, IProgressMonitor progressMonitor) {
        this.selectedElement = modelElement;
        this.progressMonitor = progressMonitor;
    }

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            try {
                if (this.selectedElement != null) {
                    RefinementMultiple refinement = new RefinementMultiple((NamedElement)this.selectedElement);
                    refinement.execute(this.progressMonitor);
                }
            }
            catch (ProcessorException exception) {
                this._logger.error((Object)new EmbeddedMessage(exception.getMessage(), "Refinement"));
                LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
    }
}

