/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.handlers.attachment;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.attachment.IAttachmentHandler;
import org.polarsys.capella.core.projection.common.handlers.log.LogHelper;
import org.polarsys.capella.core.projection.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.Messages;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public class DefaultAttachmentHandler
implements IAttachmentHandler {
    @Override
    public boolean isApplicable(EClass clazz_p, EStructuralFeature feature_p) {
        return EcoreUtil2.isEqualOrSuperClass((EClass)feature_p.getEContainingClass(), (EClass)clazz_p);
    }

    @Override
    public boolean attachElementByRel(EObject element_p, EObject relatedElement_p, EReference relationship_p) {
        if (!this.isApplicable(element_p.eClass(), (EStructuralFeature)relationship_p)) {
            LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_FeatureNonApplicable, (Object[])new Object[]{relationship_p.getName(), ((EClass)relationship_p.eContainer()).getName(), element_p.eClass().getName()}), ProjectionMessages.Activity_Transformation);
        } else if (!relationship_p.isChangeable() || relationship_p.isDerived()) {
            LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_FeatureDerivedOrNonChangeable, (Object)relationship_p.getName(), (Object)((EClass)relationship_p.eContainer()).getName()), ProjectionMessages.Activity_Transformation);
        } else {
            boolean done = false;
            boolean alreadyExist = false;
            try {
                if (relationship_p.isContainment()) {
                    HoldingResourceHelper.ensureMoveElement((EObject)relatedElement_p, (EObject)element_p);
                }
                if (relationship_p.isMany()) {
                    EList tmp = (EList)element_p.eGet((EStructuralFeature)relationship_p);
                    if (tmp.contains((Object)relatedElement_p)) {
                        alreadyExist = true;
                    } else {
                        tmp.add((Object)relatedElement_p);
                        done = true;
                    }
                } else if (relatedElement_p.equals(element_p.eGet((EStructuralFeature)relationship_p))) {
                    alreadyExist = true;
                } else {
                    element_p.eSet((EStructuralFeature)relationship_p, (Object)relatedElement_p);
                    done = true;
                }
            }
            catch (ArrayStoreException exception) {
                done = false;
            }
            catch (IllegalArgumentException exception) {
                done = false;
            }
            if (done) {
                if (relationship_p.isContainment()) {
                    LogHelper.getInstance().info(NLS.bind((String)Messages.TigerRelationshipHelper_ContainedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement_p), EObjectLabelProviderHelper.getText((EObject)element_p), relationship_p.getName()}), new Object[]{relatedElement_p, element_p}, "");
                } else {
                    LogHelper.getInstance().info(NLS.bind((String)Messages.TigerRelationshipHelper_ReferencedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement_p), EObjectLabelProviderHelper.getText((EObject)element_p), relationship_p.getName()}), new Object[]{relatedElement_p, element_p}, "");
                }
            } else if (!done && !alreadyExist) {
                if (relationship_p.isContainment()) {
                    LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_ShouldBeContainedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement_p), EObjectLabelProviderHelper.getText((EObject)element_p), relationship_p.getName()}), new Object[]{relatedElement_p, element_p}, "");
                } else {
                    LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_ShouldBeReferencedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement_p), EObjectLabelProviderHelper.getText((EObject)element_p), relationship_p.getName()}), new Object[]{relatedElement_p, element_p}, "");
                }
            }
        }
        return false;
    }

    @Override
    public void updateElementAttribute(EObject sourceElement_p, EObject targetElement_p, EAttribute feature_p, IContext context_p) {
        EAttribute attribute = feature_p;
        if (this.isApplicable(sourceElement_p.eClass(), (EStructuralFeature)attribute)) {
            Object valueTarget;
            Object valueSource = sourceElement_p.eGet((EStructuralFeature)attribute);
            if (this.isApplicable(targetElement_p.eClass(), (EStructuralFeature)attribute) && this.shouldUpdateAttribute(sourceElement_p, targetElement_p, feature_p, valueSource, valueTarget = targetElement_p.eGet((EStructuralFeature)attribute), context_p)) {
                if (valueTarget != null) {
                    LogHelper.getInstance().debug(NLS.bind((String)Messages.TigerRelationshipHelper_UpdateAttribute, (Object[])new Object[]{attribute.getName(), LogHelper.getInstance().getText(targetElement_p), LogHelper.getInstance().getText(valueTarget), LogHelper.getInstance().getText(valueSource)}), targetElement_p, ProjectionMessages.Activity_Transformation);
                }
                targetElement_p.eSet((EStructuralFeature)attribute, valueSource);
            }
        }
    }

    protected Collection<EObject> retrieveReferenceAsList(EObject object_p, EReference reference_p) {
        if (this.isApplicable(object_p.eClass(), (EStructuralFeature)reference_p)) {
            Object sourceReference = object_p.eGet((EStructuralFeature)reference_p);
            if (sourceReference instanceof Collection) {
                return (Collection)sourceReference;
            }
            return Collections.singleton((EObject)sourceReference);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void attachTracedElements(EObject source_p, EObject target_p, EReference feature_p, IContext context_p) {
        for (EObject traced : this.retrieveReferenceAsList(source_p, feature_p)) {
            for (EObject related : TraceabilityHandlerHelper.getInstance(context_p).retrieveTracedElements(traced, context_p)) {
                this.attachElementByRel(target_p, related, feature_p);
            }
        }
    }

    @Override
    public void attachToBestElement(EObject element_p, EObject result_p, EReference reference_p, IContext context_p) {
        TigerRelationshipHelper.attachToBestElement((EObject)element_p, (EReference)reference_p, (ITransfo)context_p.getTransfo());
    }

    protected boolean shouldUpdateAttribute(EObject sourceElement_p, EObject targetElement_p, EAttribute feature_p, Object valueSource, Object valueTarget, IContext context_p) {
        return valueSource == null && valueTarget != null || valueSource != null && !valueSource.equals(valueTarget);
    }

    @Override
    public void init(IContext context_p) {
    }

    @Override
    public void dispose(IContext context_p) {
    }
}

