/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.rules.fa;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.projection.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.projection.common.rules.core.Rule_CapellaElement;
import org.polarsys.capella.core.projection.preferences.ProjectionPreferencesPlugin;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public class Rule_FunctionalExchange
extends Rule_CapellaElement {
    public Rule_FunctionalExchange() {
        super(FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE_REALIZATION);
    }

    @Override
    public IStatus transformRequired(EObject element_p, IContext context_p) {
        IStatus result = super.transformRequired(element_p, context_p);
        if (result.isOK()) {
            FunctionalExchange ce = (FunctionalExchange)element_p;
            if (ce.getSource() == null) {
                return new Status(2, ProjectionMessages.Activity_Transformation, ProjectionMessages.SourceNull);
            }
            if (ce.getTarget() == null) {
                return new Status(2, ProjectionMessages.Activity_Transformation, ProjectionMessages.TargetNull);
            }
            if (!TransformationHandlerHelper.getInstance(context_p).isOrWillBeTransformed((EObject)ce.getSource(), context_p).isOK()) {
                return new Status(2, ProjectionMessages.Activity_Transformation, NLS.bind((String)ProjectionMessages.SourceBoundNotTransitioned, (Object)EObjectLabelProviderHelper.getText((EObject)ce.getSource())));
            }
            if (!TransformationHandlerHelper.getInstance(context_p).isOrWillBeTransformed((EObject)ce.getTarget(), context_p).isOK()) {
                return new Status(2, ProjectionMessages.Activity_Transformation, NLS.bind((String)ProjectionMessages.TargetBoundNotTransitioned, (Object)EObjectLabelProviderHelper.getText((EObject)ce.getTarget())));
            }
        }
        return result;
    }

    @Override
    protected void attachRelated(EObject element_p, EObject result_p, IContext context_p) {
        super.attachRelated(element_p, result_p, context_p);
        FunctionalExchange transfoSource = (FunctionalExchange)element_p;
        FunctionalExchange exchange = (FunctionalExchange)result_p;
        if (this.isFirstAttach(element_p, result_p, context_p)) {
            TigerRelationshipHelper.attachTransformedContainedElementsInBestContainer((EObject)element_p, (ITransfo)context_p.getTransfo(), (EReference)FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTIONAL_EXCHANGES, (EReference)FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTIONAL_EXCHANGES, (EClass)this.getTargetType(), (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
            ActivityNode inSrc = transfoSource.getTarget();
            ActivityNode inTgt = (ActivityNode)Query.retrieveFirstTransformedElement((EObject)inSrc, (ITransfo)context_p.getTransfo());
            ActivityNode outSrc = transfoSource.getSource();
            ActivityNode outTgt = (ActivityNode)Query.retrieveFirstTransformedElement((EObject)outSrc, (ITransfo)context_p.getTransfo());
            exchange.setSource(outTgt);
            exchange.setTarget(inTgt);
        }
        TigerRelationshipHelper.attachToBestElement((EObject)element_p, (EReference)FaPackage.Literals.FUNCTIONAL_EXCHANGE__EXCHANGED_ITEMS, (ITransfo)context_p.getTransfo());
        TigerRelationshipHelper.attachTransformedRelatedElements((EObject)element_p, (EReference)FaPackage.Literals.FUNCTIONAL_EXCHANGE__CATEGORIES, (ITransfo)context_p.getTransfo());
    }

    @Override
    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveGoDeep(source_p, result_p, context_p);
        FunctionalExchange sourceElement = (FunctionalExchange)source_p;
        if (sourceElement.getExchangedItems().size() > 0 && ProjectionPreferencesPlugin.getDefault().transitionExchangeItemWhileFunctionalTransition()) {
            result_p.addAll((Collection<EObject>)sourceElement.getExchangedItems());
        }
        result_p.add((EObject)sourceElement.getSource());
        result_p.add((EObject)sourceElement.getTarget());
        result_p.addAll((Collection<EObject>)sourceElement.getCategories());
    }

    @Override
    protected EObject getDefaultContainer(EObject element_p, EObject result_p, IContext context_p) {
        AbstractFunction root = FunctionExt.getRootFunction((AbstractFunction)((AbstractFunction)element_p));
        AbstractFunction newRoot = (AbstractFunction)Query.retrieveFirstTransformedElement((EObject)root, (ITransfo)context_p.getTransfo(), (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
        return newRoot;
    }

    @Override
    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject parent = element_p.eContainer();
        while (parent != null) {
            List<EObject> elements = TraceabilityHandlerHelper.getInstance(context_p).retrieveTracedElements(parent, context_p);
            if (elements.size() > 0) {
                EObject commonElement = elements.get(0);
                return commonElement;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    @Override
    protected void retrieveContainer(EObject element_p, List<EObject> result_p, IContext context_p) {
    }
}

