/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.core.task;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.adapter.TaskProductionAdapter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.log.ViewpointDslLogger;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.core.extension.IExtensionFilter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.data.LauncherExtension;

public class FilterGeneratorExtensionByTargetApplicationTask
extends TaskProductionAdapter {
    public static final String collectedExtensionPointContributions = "collected.extension.point.contributions";
    public static final String filteredExtensionPointContributions = "filtered.extension.point.contributions";

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        ArrayList<LauncherExtension> holdedExtensionPointContributions = new ArrayList<LauncherExtension>();
        List extensionPointContributions_Value = (List)productionContext.getInputValue((Object)collectedExtensionPointContributions, List.class);
        if (extensionPointContributions_Value == null) {
            throw new IllegalArgumentException("Mondatory contract Collected.extension.point.contributions has no value.");
        }
        EMFDomain domainModel = (EMFDomain)productionContext.getInputValue((Object)"vpdesc.model", EMFDomain.class);
        String targetApplication = this.getTargetApplication(domainModel);
        if (targetApplication == null || targetApplication != null && targetApplication.trim().length() == 0) {
            holdedExtensionPointContributions.addAll(extensionPointContributions_Value);
        } else {
            for (LauncherExtension launcherExtension : extensionPointContributions_Value) {
                boolean noFilter = true;
                IConfigurationElement[] iConfigurationElementArray = launcherExtension.iExtension.getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if (iConfigurationElement.getName().equals("filter")) {
                        boolean filterOK = true;
                        String extensionTargetApplication = iConfigurationElement.getAttribute("TargetApplication");
                        if (extensionTargetApplication != null) {
                            noFilter = false;
                            filterOK &= extensionTargetApplication.equals(targetApplication);
                        }
                        try {
                            IExtensionFilter createExecutableExtension;
                            String extensionJava = iConfigurationElement.getAttribute("java");
                            if (extensionJava != null && extensionJava.length() > 0 && (createExecutableExtension = (IExtensionFilter)iConfigurationElement.createExecutableExtension("java")) != null) {
                                noFilter = false;
                                filterOK &= createExecutableExtension.accept(domainModel);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        if (filterOK) {
                            holdedExtensionPointContributions.add(launcherExtension);
                            break;
                        }
                    }
                    ++n2;
                }
                if (!noFilter) continue;
                holdedExtensionPointContributions.add(launcherExtension);
            }
        }
        productionContext.setOutputValue((Object)filteredExtensionPointContributions, holdedExtensionPointContributions);
    }

    private String getTargetApplication(EMFDomain domainModel) {
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource domainResource = rSet.getResource(domainModel.getUri(), true);
        if (!domainResource.getContents().isEmpty()) {
            Viewpoint viewpoint = (Viewpoint)domainResource.getContents().get(0);
            return VpDslConfigurationHelper.getTargetApplication((Object)viewpoint);
        }
        ViewpointDslLogger.doLogWarning((String)"Model is Empty !!");
        return null;
    }
}

