/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.diffmerge.ui.specification.AbstractScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;

public class URIScopeDefinition
extends AbstractScopeDefinition {
    public URIScopeDefinition(URI uri_p, String label_p, boolean editable_p) {
        super(uri_p, label_p != null ? label_p : UIUtil.simplifyURI(uri_p), editable_p);
    }

    public IEditableModelScope createScope(Object context_p) {
        Object defaultContext;
        IEditableModelScope result = null;
        if (context_p instanceof EditingDomain) {
            result = this.createScopeOnEditingDomain((EditingDomain)context_p);
        } else if (context_p instanceof ResourceSet) {
            result = this.createScopeOnResourceSet((ResourceSet)context_p);
        } else if (context_p == null && (defaultContext = this.getDefaultContext()) != null) {
            result = this.createScope(defaultContext);
        }
        return result;
    }

    protected IEditableModelScope createScopeOnEditingDomain(EditingDomain editingDomain_p) {
        return new FragmentedModelScope(this.getEntrypoint(), editingDomain_p, !this.isEditable());
    }

    protected IEditableModelScope createScopeOnResourceSet(ResourceSet resourceSet_p) {
        return new FragmentedModelScope(this.getEntrypoint(), resourceSet_p, !this.isEditable());
    }

    protected Object getDefaultContext() {
        return new ResourceSetImpl();
    }

    public URI getEntrypoint() {
        return (URI)super.getEntrypoint();
    }

    public String getShortLabel() {
        String result = super.getShortLabel();
        URI uri = this.getEntrypoint();
        if (uri.isFile() || uri.isPlatformResource()) {
            result = uri.trimFileExtension().lastSegment();
        }
        result = UIUtil.simplifyURI(result);
        return result;
    }
}

