/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.utils.saxparser.SaxParserHelper;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CapellaElementInDescriptionExistanceCheck
extends AbstractValidationRule {
    protected Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");
    protected StringBuilder desc = null;

    public IStatus validate(IValidationContext ctx) {
        IStatus[] result;
        block11: {
            CapellaElement capellaElement;
            String description;
            EObject target = ctx.getTarget();
            result = new IStatus[1];
            if (target != null && target instanceof CapellaElement && (description = (capellaElement = (CapellaElement)target).getDescription()) != null && !description.isEmpty()) {
                description = SaxParserHelper.escapeSpecialCharacter((String)description);
                this.desc = new StringBuilder();
                this.desc.append("<rootSAX>");
                this.desc.append(description);
                this.desc.append("</rootSAX>");
                SAXParser saxParser = null;
                StringReader reader = null;
                try {
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setValidating(false);
                    saxParser = saxFactory.newSAXParser();
                    LocalDefaultHandler handler = new LocalDefaultHandler(capellaElement, result, ctx);
                    InputSource is = new InputSource();
                    reader = new StringReader(this.desc.toString());
                    is.setCharacterStream(reader);
                    saxParser.parse(is, (DefaultHandler)handler);
                }
                catch (SAXParseException ex) {
                    IStatus iStatus = ctx.createFailureStatus(new Object[]{"Invalid description format at line " + ex.getLineNumber()});
                    if (reader != null && saxParser != null) {
                        reader.close();
                        saxParser.reset();
                    }
                    return iStatus;
                }
                catch (Exception exception_p) {
                    try {
                        StringBuilder loggerMessage = new StringBuilder("Invalid description format");
                        this.logger.debug((Object)loggerMessage.toString(), (Throwable)exception_p);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (reader != null && saxParser != null) {
                            reader.close();
                            saxParser.reset();
                        }
                    }
                }
                if (reader == null || saxParser == null) break block11;
                reader.close();
                saxParser.reset();
            }
        }
        if (result[0] != null) {
            return ctx.createFailureStatus(new Object[]{"HyperLinks to capella element or diagram does not exist in model any more"});
        }
        return ctx.createSuccessStatus();
    }

    protected String getName(EObject object) {
        DRepresentation res;
        String repName;
        String result = null;
        if (object != null && ((result = CapellaElementExt.getName((EObject)object)) == null || result.isEmpty() && object instanceof DRepresentation) && (repName = (res = (DRepresentation)object).getName()) != null) {
            result = repName;
        }
        return result;
    }

    public final class LocalDefaultHandler
    extends DefaultHandler {
        private final CapellaElement capellaElement;
        private final IStatus[] result;
        private final IValidationContext ctx;

        public LocalDefaultHandler(CapellaElement capellaElement, IStatus[] result, IValidationContext ctx) {
            this.capellaElement = capellaElement;
            this.result = result;
            this.ctx = ctx;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("a")) {
                int i = 0;
                while (i < attributes.getLength()) {
                    EObject eObject;
                    String attValue = attributes.getValue(i);
                    String attName = attributes.getQName(i);
                    if (attValue != null && !attValue.isEmpty() && qName.equalsIgnoreCase("a") && attName.equalsIgnoreCase("href") && (eObject = SaxParserHelper.getEObjectFromHrefAttribute((EObject)this.capellaElement, (String)attValue)) == null) {
                        this.result[0] = this.ctx.createFailureStatus(new Object[0]);
                        break;
                    }
                    ++i;
                }
            }
        }
    }
}

