/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.utils.saxparser.SaxParserHelper;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CapellaElementInDescriptionNameCheck
extends AbstractValidationRule {
    protected Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");
    protected StringBuilder _description = null;

    public IStatus validate(final IValidationContext ctx_p) {
        IStatus[] result;
        block9: {
            CapellaElement capellaElement;
            String description;
            EObject target = ctx_p.getTarget();
            result = new IStatus[1];
            if (target != null && target instanceof CapellaElement && (description = (capellaElement = (CapellaElement)target).getDescription()) != null && !description.isEmpty()) {
                description = SaxParserHelper.escapeSpecialCharacter((String)description);
                this._description = new StringBuilder();
                this._description.append("<rootSAX>");
                this._description.append(description);
                this._description.append("</rootSAX>");
                SAXParser saxParser = null;
                StringReader reader = null;
                try {
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setValidating(false);
                    saxParser = saxFactory.newSAXParser();
                    DefaultHandler handler = new DefaultHandler(){
                        EObject elementFound = null;
                        StringBuilder elementValue = new StringBuilder();

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            if (qName.equalsIgnoreCase("a")) {
                                this.elementValue = new StringBuilder(0);
                                int i = 0;
                                while (i < attributes.getLength()) {
                                    EObject eObject;
                                    String attValue = attributes.getValue(i);
                                    String attQName = attributes.getQName(i);
                                    if (attValue != null && !attValue.isEmpty() && qName.equalsIgnoreCase("a") && attQName.equalsIgnoreCase("href") && (eObject = SaxParserHelper.getEObjectFromHrefAttribute((EObject)capellaElement, (String)attValue)) != null && (eObject instanceof CapellaElement || eObject instanceof DRepresentation)) {
                                        this.elementFound = eObject;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        }

                        @Override
                        public void characters(char[] ch, int start, int length) throws SAXException {
                            String string = new String(ch, start, length);
                            this.elementValue.append(string);
                        }

                        @Override
                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            if (qName.equalsIgnoreCase("a") && this.elementFound != null) {
                                String name = CapellaElementInDescriptionNameCheck.this.getName(this.elementFound);
                                String value = this.elementValue.toString();
                                if (!name.equals(value = value.replaceAll("\\s+", " "))) {
                                    result[0] = ctx_p.createFailureStatus(new Object[0]);
                                }
                                this.elementFound = null;
                                this.elementValue = new StringBuilder();
                            }
                        }
                    };
                    InputSource is = new InputSource();
                    reader = new StringReader(this._description.toString());
                    is.setCharacterStream(reader);
                    saxParser.parse(is, handler);
                }
                catch (SAXParseException ex_p) {
                    IStatus iStatus = ctx_p.createFailureStatus(new Object[]{"Invalid description format at line " + ex_p.getLineNumber()});
                    reader.close();
                    saxParser.reset();
                    return iStatus;
                }
                catch (Exception exception_p) {
                    try {
                        StringBuilder loggerMessage = new StringBuilder("Invalid description format");
                        this._logger.debug((Object)loggerMessage.toString(), (Throwable)exception_p);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        reader.close();
                        saxParser.reset();
                    }
                }
                reader.close();
                saxParser.reset();
            }
        }
        if (result[0] != null) {
            return ctx_p.createFailureStatus(new Object[]{"HyperLinks to capella element or diagram in the description are not up to date"});
        }
        return ctx_p.createSuccessStatus();
    }

    protected String getName(EObject object_p) {
        DRepresentation res;
        String repName;
        String result = null;
        if (object_p != null && ((result = CapellaElementExt.getName((EObject)object_p)) == null || result.isEmpty()) && object_p instanceof DRepresentation && (repName = (res = (DRepresentation)object_p).getName()) != null) {
            result = repName;
        }
        return result;
    }
}

