/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.data.modellingcore.AbstractRelationship;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CapellaElementNamingConflictDiagram
extends AbstractValidationRule {
    private static final String TYPE_SUFFIX = ") ";
    private static final String TYPE_PREFIX = " (";

    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof CapellaElement) {
            Session curSession;
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            boolean hasConflict = false;
            HashMap<String, List<String>> typesAndNames = new HashMap<String, List<String>>();
            CapellaElement elt = (CapellaElement)eObj;
            if (!(elt instanceof AbstractRelationship) && (curSession = SessionManager.INSTANCE.getSession((EObject)elt)) != null) {
                Collection allRepresentations = DialectManager.INSTANCE.getRepresentations((EObject)elt, curSession);
                for (DRepresentation dRepresentation : allRepresentations) {
                    if (!(dRepresentation instanceof DDiagram)) continue;
                    DDiagram diagram = (DDiagram)dRepresentation;
                    String currentElementName = diagram.getName();
                    String currentElementType = diagram.eClass().getName();
                    hasConflict = this.checkTheNamingConflict(ctx_p, statuses, hasConflict, typesAndNames, elt, currentElementName, currentElementType);
                }
            }
            if (hasConflict) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
            }
        }
        return ctx_p.createSuccessStatus();
    }

    private boolean checkTheNamingConflict(IValidationContext ctx_p, Collection<IStatus> statuses, boolean hasConflict_p, Map<String, List<String>> typesAndNames, CapellaElement elt, String currentElementName, String currentElementType) {
        boolean hasConflict = hasConflict_p;
        if (!typesAndNames.containsKey(currentElementType)) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(currentElementName);
            typesAndNames.put(currentElementType, names);
        } else {
            List<String> existingNamesForTypes = typesAndNames.get(currentElementType);
            boolean alreadyExist = false;
            for (String existingName : existingNamesForTypes) {
                if (!existingName.equalsIgnoreCase(currentElementName)) continue;
                hasConflict = true;
                alreadyExist = true;
                String currentConflict = TYPE_PREFIX + currentElementType + TYPE_SUFFIX + currentElementName;
                IStatus failureStatus = this.createFailureStatus(ctx_p, new Object[]{elt.eClass().getName(), elt.getLabel(), currentConflict});
                statuses.add(failureStatus);
                break;
            }
            if (!alreadyExist) {
                existingNamesForTypes.add(currentElementName);
            }
        }
        return hasConflict;
    }
}

