/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.diagram.template;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.diagram.template.DataClassesPageHelper;

public class DataClassesPage
extends WizardPage {
    private Collection<Class> classes;
    final Collection<Class> selectedClass = new HashSet<Class>(1);
    private ListViewer listViewer;
    private Button diagramOption;
    private Button diagramExtensionOption;
    private boolean isDiagramExtension = false;

    protected DataClassesPage(String pageName) {
        super(pageName);
    }

    protected DataClassesPage(String pageName, Collection<Class> classes) {
        this(pageName);
        this.classes = classes;
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite listComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        listComposite.setLayout((Layout)layout);
        Composite diagramRadioButtonComposite = new Composite(listComposite, 0);
        diagramRadioButtonComposite.setLayout((Layout)new RowLayout(256));
        this.diagramOption = new Button(diagramRadioButtonComposite, 16);
        this.diagramExtensionOption = new Button(diagramRadioButtonComposite, 16);
        this.diagramOption.setText("New diagram");
        this.diagramExtensionOption.setText("New diagram extension");
        this.diagramOption.setSelection(true);
        this.diagramOption.addSelectionListener((SelectionListener)new DiagramSelectionButtonListener());
        this.diagramExtensionOption.addSelectionListener((SelectionListener)new DiagramSelectionButtonListener());
        Label label = new Label(listComposite, 0);
        label.setText("Candidates viewpoint classes:");
        this.listViewer = new ListViewer(listComposite, 2560);
        this.listViewer.getList().setLayoutData((Object)new GridData(1808));
        this.listViewer.setComparator(new ViewerComparator());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ((Class)element).getName();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataClassesPage.this.selectedClass.clear();
                Class tmp = (Class)((IStructuredSelection)event.getSelection()).getFirstElement();
                DataClassesPage.this.selectedClass.add(tmp);
            }
        });
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }
        });
        this.listViewer.setInput(this.classes);
        if (this.listViewer.getList().getItems().length > 0) {
            this.listViewer.setSelection((ISelection)new StructuredSelection(this.listViewer.getElementAt(0)), true);
        }
        this.setControl((Control)parent);
        this.setVisible(true);
    }

    public Collection<Class> getSelectedClass() {
        return this.selectedClass;
    }

    public boolean isUserSelectedDomainContext() {
        return !this.selectedClass.isEmpty();
    }

    private void updateIsDiagramExtension(boolean isExtension) {
        this.isDiagramExtension = isExtension;
    }

    public void dispose() {
        this.getSelectedClass().clear();
    }

    public boolean isDiagramExtension() {
        return this.isDiagramExtension;
    }

    class DiagramSelectionButtonListener
    implements SelectionListener {
        DiagramSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            boolean extensionActivated = DataClassesPage.this.diagramExtensionOption.getSelection();
            DataClassesPage.this.updateIsDiagramExtension(extensionActivated);
            if (extensionActivated) {
                Collection<Class> emdeExtensionClasses = DataClassesPageHelper.getEmdeExtensionClasses(DataClassesPage.this.classes);
                DataClassesPageHelper.updateListViewerContent(DataClassesPage.this.listViewer, emdeExtensionClasses);
            } else {
                DataClassesPageHelper.updateListViewerContent(DataClassesPage.this.listViewer, DataClassesPage.this.classes);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

