/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.merge;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.merge.CategoryFilter;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.system.topdown.handlers.merge.Messages;
import org.polarsys.capella.core.transition.system.topdown.handlers.transformation.TopDownTransformationHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class RemoveRealizedCategoryFilter
extends CategoryFilter {
    public static final String ID = RemoveRealizedCategoryFilter.class.getCanonicalName();

    public RemoveRealizedCategoryFilter(IContext context) {
        super(context, ID, Messages.RemoveRealizedCategoryFilter, Messages.RemoveRealizedCategoryFilter_Description, null);
        this.setCategorySet("category.business");
        this.setInFocusMode(true);
        this.setVisible(false);
        this.setActive(false);
    }

    protected boolean isTrace(EObject element, IContext context) {
        return TopDownTransformationHelper.getInstance(context).isTrace(element, context);
    }

    protected BlockArchitecture getSourceArchitecture(EObject source_p, IContext context_p) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source_p);
        Collection selection = (Collection)context_p.get((Object)"TRANSITION_SOURCES");
        if (selection.size() > 0) {
            EObject source = (EObject)selection.toArray()[0];
            architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        }
        return architecture;
    }

    public void setDependencies(IMergeableDifference difference) {
        super.setDependencies(difference);
        if (difference instanceof IReferenceValuePresence) {
            IReferenceValuePresence presence = (IReferenceValuePresence)difference;
            IMatch element = presence.getElementMatch();
            IMatch value = presence.getValue();
            EObject valueElement = value.get(Role.REFERENCE);
            if (valueElement == null) {
                return;
            }
            Collection diffs = element.getReferenceDifferences(presence.getFeature());
            for (IReferenceValuePresence diff : diffs) {
                IMatch ei2 = diff.getValue();
                EObject eiTransfo2 = ei2.get(Role.TARGET);
                BlockArchitecture architecture = this.getSourceArchitecture(valueElement, this.context);
                BlockArchitecture current = BlockArchitectureExt.getRootBlockArchitecture((EObject)eiTransfo2);
                if (current == null || !current.eClass().isInstance((Object)architecture)) continue;
                ITraceabilityHandler sourceHandler = (ITraceabilityHandler)this.context.get((Object)"TSMH");
                Collection sources = sourceHandler.retrieveSourceElements(valueElement, this.context);
                List<EObject> sources2 = Collections.singletonList(eiTransfo2);
                if (!sources2.containsAll(sources) || diff == difference) continue;
                ((IMergeableDifference.Editable)diff).markRequires(difference, Role.TARGET);
                ((IMergeableDifference.Editable)difference).markRequires((IMergeableDifference)diff, Role.TARGET);
            }
        }
    }

    public boolean covers(IDifference difference) {
        return difference instanceof IReferenceValuePresence && ((IReferenceValuePresence)difference).getElementMatch().get(Role.REFERENCE) != null;
    }
}

