/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.traceability.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.handlers.traceability.LibraryTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.RealizationLinkTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.ReconciliationTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeTargetConfiguration
extends org.polarsys.capella.core.transition.system.handlers.traceability.config.MergeTargetConfiguration {
    protected void initHandlers(IContext context) {
        this.addHandler(context, (ITraceabilityHandler)new TopDownTargetReconciliationTraceabilityHandler(this.getIdentifier(context)));
        this.addHandler(context, (ITraceabilityHandler)new TopDownTargetSIDTraceabilityHandler(this.getIdentifier(context)));
        this.addHandler(context, (ITraceabilityHandler)new LibraryTraceabilityHandler());
    }

    public Collection<EObject> retrieveTracedElementsByRealization(EObject object, IContext context) {
        ITraceabilityHandler handler = this.getDefinedHandler(context, RealizationLinkTraceabilityHandler.class);
        if (handler != null) {
            return handler.retrieveTracedElements(object, context);
        }
        return Collections.emptyList();
    }

    protected BlockArchitecture getSourceArchitecture(SystemEngineering source, IContext context) {
        PhysicalArchitecture architecture = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)source);
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (selection.size() > 0) {
            EObject sourceSelection = (EObject)selection.toArray()[0];
            architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)sourceSelection);
        }
        return architecture;
    }

    protected BlockArchitecture getTargetArchitecture(EObject target, IContext context) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (selection.size() > 0) {
            EObject source = (EObject)selection.toArray()[0];
            architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        }
        EClass clazz = TransformationHandlerHelper.getInstance((IContext)context).getTargetType((EObject)architecture, context);
        for (BlockArchitecture archi : architecture.getAllocatingArchitectures()) {
            if (!clazz.isInstance((Object)archi)) continue;
            return archi;
        }
        return architecture;
    }

    public boolean useHandlerForTracedElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForTracedElements(source, handler, context);
        if (result && handler instanceof RealizationLinkTraceabilityHandler) {
            if (source instanceof SystemEngineering) {
                result = false;
            }
            if (source instanceof BlockArchitecture) {
                result = false;
            }
        }
        if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
            return handler instanceof LibraryTraceabilityHandler;
        }
        return result;
    }

    public boolean useHandlerForSourceElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForSourceElements(source, handler, context);
        if (result) {
            if (handler instanceof RealizationLinkTraceabilityHandler) {
                if (source instanceof SystemEngineering) {
                    result = false;
                }
                if (source instanceof BlockArchitecture) {
                    result = false;
                }
            }
            if (handler instanceof ReconciliationTraceabilityHandler) {
                if (source instanceof StateMachine) {
                    result = false;
                }
                if (source instanceof Region) {
                    result = false;
                }
            }
        }
        if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
            return handler instanceof LibraryTraceabilityHandler;
        }
        return result;
    }

    protected class TopDownTargetReconciliationTraceabilityHandler
    extends ReconciliationTraceabilityHandler {
        public TopDownTargetReconciliationTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected void initializeDataPkg(DataPkg source, DataPkg target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            if (source.eClass().equals(target.eClass())) {
                this.addMapping((MappingTraceability)map, (EObject)source, (EObject)target, context);
            }
        }

        protected void initializeComponent(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeComponent(source, target, context, map);
            if (source != null && target != null && !source.eClass().equals(target.eClass())) {
                this.addMapping((MappingTraceability)map, (EObject)ComponentExt.getDataPkg((Component)source, (boolean)false), (EObject)ComponentExt.getDataPkg((Component)target, (boolean)false), context);
                this.addMapping((MappingTraceability)map, (EObject)ComponentExt.getInterfacePkg((Component)source, (boolean)false), (EObject)ComponentExt.getInterfacePkg((Component)target, (boolean)false), context);
            }
            this.addInterfaceUseReconciliation(source, target, context, map);
            this.addInterfaceImplementationReconciliation(source, target, context, map);
            this.addCommunicationLinkReconciliation(source, target, context, map);
        }

        protected void addCommunicationLinkReconciliation(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            ArrayList<CommunicationLink> unmatchedLinks = new ArrayList<CommunicationLink>(1);
            for (CommunicationLink sLink : source.getOwnedCommunicationLinks()) {
                boolean match = false;
                if (sLink.getExchangeItem() == null || !MergeTargetConfiguration.this.retrieveTracedElementsByRealization((EObject)sLink, context).isEmpty()) continue;
                for (CommunicationLink tLink : target.getOwnedCommunicationLinks()) {
                    if (tLink.getExchangeItem() == null || !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink, context).isEmpty() || !sLink.getExchangeItem().equals(tLink.getExchangeItem()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getExchangeItem(), context).contains(sLink.getExchangeItem()) || tLink.getKind() != sLink.getKind()) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    match = true;
                    break;
                }
                if (match) continue;
                unmatchedLinks.add(sLink);
            }
            block2: for (CommunicationLink sLink : unmatchedLinks) {
                if (sLink.getExchangeItem() == null) continue;
                for (CommunicationLink tLink : target.getOwnedCommunicationLinks()) {
                    if (tLink.getExchangeItem() == null || !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink, context).isEmpty() || !sLink.getExchangeItem().equals(tLink.getExchangeItem()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getExchangeItem(), context).contains(sLink.getExchangeItem())) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    continue block2;
                }
            }
        }

        protected void addInterfaceUseReconciliation(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            block0: for (InterfaceUse sLink : source.getUsedInterfaceLinks()) {
                if (sLink.getUsedInterface() == null) continue;
                for (InterfaceUse tLink : target.getUsedInterfaceLinks()) {
                    if (tLink.getUsedInterface() == null || !sLink.getUsedInterface().equals(tLink.getUsedInterface()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getUsedInterface(), context).contains(sLink.getUsedInterface())) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    continue block0;
                }
            }
        }

        protected void addInterfaceImplementationReconciliation(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            block0: for (InterfaceImplementation sLink : source.getImplementedInterfaceLinks()) {
                if (sLink.getImplementedInterface() == null) continue;
                for (InterfaceImplementation tLink : target.getImplementedInterfaceLinks()) {
                    if (tLink.getImplementedInterface() == null || !sLink.getImplementedInterface().equals(tLink.getImplementedInterface()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getImplementedInterface(), context).contains(sLink.getImplementedInterface())) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    continue block0;
                }
            }
        }

        protected void initializeSystemEngineering(SystemEngineering source, SystemEngineering target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeSystemEngineering(source, target, context, map);
        }

        protected void initializeBlockArchitecture(BlockArchitecture source, BlockArchitecture target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getActorPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getActorPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getContext((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getContext((BlockArchitecture)target, (boolean)false), context);
            if (!(target instanceof PhysicalArchitecture) || source instanceof PhysicalArchitecture) {
                this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)target, (boolean)false), context);
            }
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getRequirementsPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getRequirementsPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)target, (boolean)false), context);
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            EObject source = (EObject)context.get((Object)"_TSRo");
            EObject target = (EObject)context.get((Object)"_TTRo");
            this.addMappings(source, target, context);
        }
    }

    protected class TopDownTargetSIDTraceabilityHandler
    extends RealizationLinkTraceabilityHandler {
        public TopDownTargetSIDTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected boolean initTraceabilityMapping(EObject source, EObject object, IContext context) {
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)object);
            return architecture == null || MergeTargetConfiguration.this.getTargetArchitecture(source, context) == architecture;
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            EObject source = (EObject)context.get((Object)"_TSRo");
            EObject target = (EObject)context.get((Object)"_TTRo");
            this.initializeMappings(source, target, context);
        }
    }
}

