/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.property.IDefaultValueProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.PropertiesSchemaConstants;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;

public class StringPropertyPreference
extends AbstractProperty
implements IEditableProperty,
IDefaultValueProperty {
    public Object getType() {
        return String.class;
    }

    public Object getValue(IPropertyContext context_p) {
        String scope = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__SCOPE);
        String preferenceId = this.getId();
        if (this.isArgumentSet(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__PREFERENCE_ID)) {
            preferenceId = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__PREFERENCE_ID);
        }
        return ScopedCapellaPreferencesStore.getInstance((String)scope).getString(preferenceId);
    }

    public void setValue(IPropertyContext context_p) {
        String scope = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__SCOPE);
        Object value = context_p.getCurrentValue((IProperty)this);
        String preferenceId = this.getId();
        if (this.isArgumentSet(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__PREFERENCE_ID)) {
            preferenceId = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__PREFERENCE_ID);
        }
        ScopedCapellaPreferencesStore.getInstance((String)scope).setValue(preferenceId, (String)this.toType(value, context_p));
    }

    public IStatus validate(Object newValue, IPropertyContext context_p) {
        try {
            if (newValue != null) {
                String value = String.valueOf(newValue);
                String validOnEmpty = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_STRING_PROPERTY__EMPTY_IS_VALID);
                if (validOnEmpty != null && "false".equals(validOnEmpty) && value.length() == 0) {
                    return new Status(4, this.getId(), "Empty value isn't valid");
                }
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, this.getId(), e.getMessage());
        }
    }

    public Object getDefaultValue(IPropertyContext context_p) {
        String argument = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__DEFAULT);
        return this.toType(argument, context_p);
    }

    public Object toType(Object value_p, IPropertyContext context_p) {
        return value_p;
    }
}

