/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.pa.validation.physicalActor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.pa.LogicalActorRealization;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_PhysicalActor_ActorRealization
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof PhysicalActor) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            PhysicalActor actor = (PhysicalActor)eObj;
            EList logicalActorRealizations = actor.getLogicalActorRealizations();
            if (logicalActorRealizations.size() < 1) {
                return ctx_p.createSuccessStatus();
            }
            for (LogicalActorRealization next : logicalActorRealizations) {
                Component allocatingComponent;
                Component allocatedComponent = next.getAllocatedComponent();
                if (allocatedComponent == null || !(allocatedComponent instanceof LogicalActor)) {
                    statuses.add(ctx_p.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") contain realization with inconsistent Target (it should be Logical Actor)"}));
                }
                if ((allocatingComponent = next.getAllocatingComponent()) != null && allocatingComponent instanceof PhysicalActor) continue;
                statuses.add(ctx_p.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") contain realization with inconsistent target (it should be Physical Actor)"}));
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

