/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.export.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.polarsys.capella.common.helpers.export.utils.CSVWriterMessages;

public class CSVWriter {
    private PrintWriter _outputStream = null;
    private String _fileName = null;
    private boolean _firstColumn = true;
    private boolean _useCustomRecordDelimiter = false;
    private Charset _charset = null;
    private UserSettings _userSettings = new UserSettings();
    private boolean _initialized = false;
    private boolean _closed = false;
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final int ESCAPE_MODE_DOUBLED = 1;
    private static final int ESCAPE_MODE_BACKSLASH = 2;

    public CSVWriter(String fileName, char delimiter, Charset charset) {
        if (fileName == null) {
            throw new IllegalArgumentException(CSVWriterMessages.errNullFileName);
        }
        if (charset == null) {
            throw new IllegalArgumentException(CSVWriterMessages.errNullCharset);
        }
        this._fileName = fileName;
        this._userSettings.Delimiter = delimiter;
        this._charset = charset;
    }

    public CSVWriter(String fileName) {
        this(fileName, ',', Charset.forName(DEFAULT_CHARSET));
    }

    public CSVWriter(Writer outputStream, char delimiter) {
        if (outputStream == null) {
            throw new IllegalArgumentException(CSVWriterMessages.errNullOutputStream);
        }
        this._outputStream = new PrintWriter(outputStream);
        this._userSettings.Delimiter = delimiter;
        this._initialized = true;
    }

    public CSVWriter(OutputStream outputStream, char delimiter) {
        if (outputStream == null) {
            throw new IllegalArgumentException(CSVWriterMessages.errNullOutputStream);
        }
        this._outputStream = new PrintWriter(outputStream);
        this._userSettings.Delimiter = delimiter;
        this._initialized = true;
    }

    public CSVWriter(OutputStream outputStream, char delimiter, Charset charset) {
        this(new OutputStreamWriter(outputStream, charset), delimiter);
    }

    public char getDelimiter() {
        return this._userSettings.Delimiter;
    }

    public void setDelimiter(char delimiter) {
        this._userSettings.Delimiter = delimiter;
    }

    public char getRecordDelimiter() {
        return this._userSettings.RecordDelimiter;
    }

    public void setRecordDelimiter(char recordDelimiter) {
        this._useCustomRecordDelimiter = true;
        this._userSettings.RecordDelimiter = recordDelimiter;
    }

    public char getTextQualifier() {
        return this._userSettings.TextQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this._userSettings.TextQualifier = textQualifier;
    }

    public boolean getUseTextQualifier() {
        return this._userSettings.UseTextQualifier;
    }

    public void setUseTextQualifier(boolean useTextQualifier) {
        this._userSettings.UseTextQualifier = useTextQualifier;
    }

    public int getEscapeMode() {
        return this._userSettings.EscapeMode;
    }

    public void setEscapeMode(int escapeMode) {
        this._userSettings.EscapeMode = escapeMode;
    }

    public void setComment(char comment) {
        this._userSettings.Comment = comment;
    }

    public char getComment() {
        return this._userSettings.Comment;
    }

    public boolean getForceQualifier() {
        return this._userSettings.ForceQualifier;
    }

    public void setForceQualifier(boolean forceQualifier) {
        this._userSettings.ForceQualifier = forceQualifier;
    }

    public void write(String content, boolean preserveSpaces) throws IOException {
        this.checkClosed();
        this.checkInit();
        String buffer = content;
        if (buffer == null) {
            buffer = "";
        }
        if (!this._firstColumn) {
            this._outputStream.write(this._userSettings.Delimiter);
        }
        boolean textQualify = this._userSettings.ForceQualifier;
        if (!preserveSpaces && buffer.length() > 0) {
            buffer = buffer.trim();
        }
        if (!textQualify && this._userSettings.UseTextQualifier && (buffer.indexOf(this._userSettings.TextQualifier) > -1 || buffer.indexOf(this._userSettings.Delimiter) > -1 || !this._useCustomRecordDelimiter && (buffer.indexOf(10) > -1 || buffer.indexOf(13) > -1) || this._useCustomRecordDelimiter && buffer.indexOf(this._userSettings.RecordDelimiter) > -1 || this._firstColumn && buffer.length() > 0 && buffer.charAt(0) == this._userSettings.Comment || this._firstColumn && buffer.length() == 0)) {
            textQualify = true;
        }
        if (this._userSettings.UseTextQualifier && !textQualify && buffer.length() > 0 && preserveSpaces) {
            char lastLetter;
            char firstLetter = buffer.charAt(0);
            if (firstLetter == ' ' || firstLetter == '\t') {
                textQualify = true;
            }
            if (!(textQualify || buffer.length() <= 1 || (lastLetter = buffer.charAt(buffer.length() - 1)) != ' ' && lastLetter != '\t')) {
                textQualify = true;
            }
        }
        if (textQualify) {
            this._outputStream.write(this._userSettings.TextQualifier);
            if (this._userSettings.EscapeMode == 2) {
                buffer = CSVWriter.replace(buffer, "\\", "\\\\");
                buffer = CSVWriter.replace(buffer, "" + this._userSettings.TextQualifier, "\\" + this._userSettings.TextQualifier);
            } else {
                buffer = CSVWriter.replace(buffer, "" + this._userSettings.TextQualifier, "" + this._userSettings.TextQualifier + this._userSettings.TextQualifier);
            }
        } else if (this._userSettings.EscapeMode == 2) {
            buffer = CSVWriter.replace(buffer, "\\", "\\\\");
            buffer = CSVWriter.replace(buffer, "" + this._userSettings.Delimiter, "\\" + this._userSettings.Delimiter);
            if (this._useCustomRecordDelimiter) {
                buffer = CSVWriter.replace(buffer, "" + this._userSettings.RecordDelimiter, "\\" + this._userSettings.RecordDelimiter);
            } else {
                buffer = CSVWriter.replace(buffer, "\r", "\\\r");
                buffer = CSVWriter.replace(buffer, "\n", "\\\n");
            }
            if (this._firstColumn && buffer.length() > 0 && buffer.charAt(0) == this._userSettings.Comment) {
                buffer = buffer.length() > 1 ? "\\" + this._userSettings.Comment + buffer.substring(1) : "\\" + this._userSettings.Comment;
            }
        }
        this._outputStream.write(buffer);
        if (textQualify) {
            this._outputStream.write(this._userSettings.TextQualifier);
        }
        this._firstColumn = false;
    }

    public void write(String content) throws IOException {
        this.write(content, false);
    }

    public void writeComment(String commentText) throws IOException {
        this.checkClosed();
        this.checkInit();
        this._outputStream.write(this._userSettings.Comment);
        this._outputStream.write(commentText);
        if (this._useCustomRecordDelimiter) {
            this._outputStream.write(this._userSettings.RecordDelimiter);
        } else {
            this._outputStream.println();
        }
        this._firstColumn = true;
    }

    public void writeRecord(String[] values, boolean preserveSpaces) throws IOException {
        if (values != null && values.length > 0) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                this.write(element, preserveSpaces);
                ++n2;
            }
            this.endRecord();
        }
    }

    public void writeRecord(String[] values) throws IOException {
        this.writeRecord(values, false);
    }

    public void endRecord() throws IOException {
        this.checkClosed();
        this.checkInit();
        if (this._useCustomRecordDelimiter) {
            this._outputStream.write(this._userSettings.RecordDelimiter);
        } else {
            this._outputStream.println();
        }
        this._firstColumn = true;
    }

    private void checkInit() throws IOException {
        if (!this._initialized) {
            if (this._fileName != null) {
                this._outputStream = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._fileName), this._charset));
            }
            this._initialized = true;
        }
    }

    public void flush() {
        this._outputStream.flush();
    }

    public void close() {
        if (!this._closed) {
            this.close(true);
            this._closed = true;
        }
    }

    private void close(boolean closing) {
        if (!this._closed) {
            if (closing) {
                this._charset = null;
            }
            try {
                if (this._initialized) {
                    this._outputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._outputStream = null;
            this._closed = true;
        }
    }

    private void checkClosed() throws IOException {
        if (this._closed) {
            throw new IOException(CSVWriterMessages.errOutputStreamAlreadyClosed);
        }
    }

    protected void finalize() throws Throwable {
        this.close(false);
        super.finalize();
    }

    public static String replace(String original, String pattern, String replace) {
        int len = pattern.length();
        int found = original.indexOf(pattern);
        if (found > -1) {
            StringBuffer sb = new StringBuffer();
            int start = 0;
            while (found != -1) {
                sb.append(original.substring(start, found));
                sb.append(replace);
                start = found + len;
                found = original.indexOf(pattern, start);
            }
            sb.append(original.substring(start));
            return sb.toString();
        }
        return original;
    }

    private class UserSettings {
        public char TextQualifier = (char)34;
        public boolean UseTextQualifier = true;
        public char Delimiter = (char)44;
        public char RecordDelimiter = '\u0000';
        public char Comment = (char)35;
        public int EscapeMode = 1;
        public boolean ForceQualifier = false;
    }
}

