/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IteratorKind;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.polarsys.capella.common.helpers.query.EObjectTypeCondition;
import org.polarsys.capella.common.helpers.query.IGetAllQueries;

public class GetAllQueries
implements IGetAllQueries {
    @Override
    public Set<EObject> getAll(EObject source, Class<?> targetType) {
        HashSet result = null;
        if (source != null) {
            EObjectTypeCondition condition = new EObjectTypeCondition(targetType);
            SELECT statement = new SELECT(new FROM(source, IteratorKind.HIERARCHICAL_LITERAL), new WHERE((EObjectCondition)condition));
            result = new HashSet(statement.execute().getEObjects());
            result.remove(source);
        }
        return result;
    }

    @Override
    public Set<EObject> getAllFiltered(EObject source, EClass targetType, List<EClass> filter) {
        HashSet<EObject> result = new HashSet<EObject>(1);
        if (source == null || targetType == null) {
            return result;
        }
        if (filter.contains(targetType)) {
            return result;
        }
        if (targetType.isSuperTypeOf(source.eClass())) {
            result.add(source);
        }
        for (EClass cls : filter) {
            if (!cls.isSuperTypeOf(source.eClass())) continue;
            return result;
        }
        EList containedElements = source.eContents();
        for (EObject object : containedElements) {
            result.addAll(this.getAllFiltered(object, targetType, filter));
        }
        return result;
    }

    @Override
    public List<EClass> getLocalSubTypes(EClass eClass) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        EPackage pkg = this.getRootPackage(eClass.getEPackage());
        TreeIterator iterator = pkg.eAllContents();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof EClass) || !eClass.isSuperTypeOf((EClass)object)) continue;
            result.add((EClass)object);
        }
        return result;
    }

    private EPackage getRootPackage(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        EPackage pkg = ePackage.getESuperPackage();
        if (pkg == null) {
            return ePackage;
        }
        return this.getRootPackage(pkg);
    }
}

