/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.viewpoints.command;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;
import org.polarsys.kitalpha.ad.metadata.metadata.ViewpointReference;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.viewpoints.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes.UsedAFViewpoints;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;

public class ViewpointsDetachmentCommand
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(ViewpointsDetachmentCommand.class);

    public void exec(Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        try {
            monitor.beginTask(Messages.REMOVE_VIEWPOINTS, 1);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            ModelScrutinyRegistry.RegistryElement regElt = Scrutineer.getRegistryElement((String)this.getModelAnalysisID());
            UsedAFViewpoints usedVpFinder = this.getUsedAFFinder(regElt);
            if (usedVpFinder != null) {
                ViewpointTreeContainer container = usedVpFinder.getAnalysisResult();
                Collection unSelectedUri = container.getUriToRemove();
                Collection unSelectedViewpoint = container.getViewpointToRemove();
                ResourceSet resourceSet = resource.getResourceSet();
                Session session = SessionManager.INSTANCE.getExistingSession(resource.getURI());
                TransactionalEditingDomain editingDomain = session != null ? session.getTransactionalEditingDomain() : TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
                if (editingDomain != null) {
                    this.cleanUnselectedUris(editingDomain, (Collection<String>)unSelectedUri, (Collection<String>)unSelectedViewpoint, subMonitor);
                } else {
                    this.cleanUnselectedUris(resourceSet, (Collection<String>)unSelectedUri, (Collection<String>)unSelectedViewpoint, (IProgressMonitor)subMonitor);
                }
            }
            subMonitor.worked(1);
            subMonitor.done();
        }
        catch (ModelScrutinyException e) {
            e.printStackTrace();
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void cleanUnselectedUris(TransactionalEditingDomain editingDomain, Collection<String> unSelectedUri, Collection<String> unSelectedViewpoint, SubMonitor monitor) {
        Command deleteCommand;
        HashSet<Object> eObjectToRemove = new HashSet<Object>();
        for (Resource resource : editingDomain.getResourceSet().getResources()) {
            if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Metadata) {
                Metadata root = (Metadata)resource.getContents().get(0);
                for (ViewpointReference uv : root.getViewpointReferences()) {
                    if (!unSelectedViewpoint.contains(uv.getVpId())) continue;
                    eObjectToRemove.add(uv);
                }
            }
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                String current_uri = eObject.eClass().getEPackage().getNsURI();
                if (!unSelectedUri.contains(current_uri)) continue;
                eObjectToRemove.add(eObject);
            }
        }
        if (eObjectToRemove != null && !eObjectToRemove.isEmpty() && (deleteCommand = DeleteCommand.create((EditingDomain)editingDomain, eObjectToRemove)).canExecute()) {
            editingDomain.getCommandStack().execute(deleteCommand);
        }
    }

    private void cleanUnselectedUris(ResourceSet set, Collection<String> unSelectedUri, Collection<String> unSelectedViewpoint, IProgressMonitor monitor) {
        for (Resource resource : set.getResources()) {
            HashSet<Object> eObjectToRemove = new HashSet<Object>();
            if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Metadata) {
                Metadata root = (Metadata)resource.getContents().get(0);
                for (ViewpointReference viewpointReference : root.getViewpointReferences()) {
                    if (!unSelectedViewpoint.contains(viewpointReference.getVpId())) continue;
                    eObjectToRemove.add(viewpointReference);
                }
            }
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                String current_uri = eObject.eClass().getEPackage().getNsURI();
                if (!unSelectedUri.contains(current_uri)) continue;
                eObjectToRemove.add(eObject);
            }
            if (eObjectToRemove == null || eObjectToRemove.isEmpty()) continue;
            for (EObject eObject : eObjectToRemove) {
                monitor.subTask(Messages.bind((String)Messages.REMOVE_OBJECT, (Object[])new Object[]{EcoreUtil.getURI((EObject)eObject), eObject.eClass().getEPackage().getNsURI()}));
                EObject rootContainer = EcoreUtil.getRootContainer((EObject)eObject);
                if (eObject.equals(rootContainer)) continue;
                EcoreUtil.delete((EObject)eObject, (boolean)false);
            }
        }
    }

    private UsedAFViewpoints getUsedAFFinder(ModelScrutinyRegistry.RegistryElement regElt) {
        Collection finders = regElt.getFinders();
        for (IScrutinize iFinder : finders) {
            if (!(iFinder instanceof UsedAFViewpoints)) continue;
            return (UsedAFViewpoints)iFinder;
        }
        return null;
    }
}

