/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.dialogs;

import java.text.Collator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractMessageDialogWithViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;

public class ImpactAnalysisDialog
extends AbstractMessageDialogWithViewer {
    protected static final int DEFAULT_COLOR_FOR_RELEVANT_ELEMENTS = 9;
    private AbstractContextMenuFiller _contextMenuManagerFiller;
    private int _foregroundColorForReferencingElements;
    private List<?> _referencingElements;
    private boolean _isMultiSelection;

    public ImpactAnalysisDialog(List<?> referencingElements_p, String dialogTitle_p, String dialogMessage_p) {
        this(referencingElements_p, dialogTitle_p, dialogMessage_p, 2, new String[]{org.polarsys.capella.common.ui.toolkit.dialogs.Messages.AbstractViewerDialog_OK_Title}, 9, false);
    }

    public ImpactAnalysisDialog(List<?> referencingElements_p, String dialogTitle_p, String dialogMessage_p, int dialogImageType_p, String[] dialogButtonLabels_p, int foregroundColorForReferencingElements_p, boolean isMultiSelection_p) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell(), dialogTitle_p, null, dialogMessage_p, dialogImageType_p, dialogButtonLabels_p, 0);
        this._referencingElements = referencingElements_p;
        this._foregroundColorForReferencingElements = foregroundColorForReferencingElements_p;
        this._isMultiSelection = isMultiSelection_p;
    }

    protected TreeViewer createViewer(Composite parent_p) {
        TreeAndListViewer treeViewer = new TreeAndListViewer(parent_p, this._isMultiSelection, 2){

            protected void createControl(Composite parent__p) {
                super.createControl(parent__p);
                this.createResourceCheckButton(parent__p);
            }

            protected void createResourceCheckButton(Composite parent__p) {
                Button resourceCheckButton = new Button(parent__p, 32);
                resourceCheckButton.setLayoutData((Object)new GridData(768));
                resourceCheckButton.setText(Messages.ImpactAnalysisDialog_ResourceButton_Title);
                resourceCheckButton.setSelection(false);
                resourceCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event_p) {
                        this.handleResourceCheckButtonClicked(((Button)event_p.widget).getSelection());
                    }
                });
            }

            protected void handleResourceCheckButtonClicked(boolean isChecked_p) {
                TreeData input = null;
                TreeViewer clientViewer = this.getClientViewer();
                List referencingElements = ((TreeData)clientViewer.getInput()).getValidElements();
                input = ImpactAnalysisDialog.this.getTreeViewerItems(isChecked_p, referencingElements);
                clientViewer.setInput((Object)input);
            }
        };
        if (this._contextMenuManagerFiller != null) {
            treeViewer.setContextMenuManagerFiller(this._contextMenuManagerFiller);
        }
        TreeViewer viewer = treeViewer.getClientViewer();
        viewer.setContentProvider((IContentProvider)new DataContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ImpactAnalysisLabelProvider(viewer, this._foregroundColorForReferencingElements));
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setSorter((ViewerSorter)new ImpactAnalysisSorter());
        return viewer;
    }

    protected TreeData getTreeViewerItems(boolean isCheckedShowResourceButton, List<Object> referencingElements) {
        TreeData input = isCheckedShowResourceButton ? new TreeData(referencingElements, null){

            protected Object filterComputedParent(Object parent__p, Object element_p) {
                Resource childResource;
                if (!(parent__p instanceof EObject) || !(element_p instanceof EObject)) {
                    return parent__p;
                }
                Object parent = parent__p;
                Resource parentResource = ((EObject)parent__p).eResource();
                if (!parentResource.equals(childResource = ((EObject)element_p).eResource())) {
                    parent = childResource;
                }
                return parent;
            }
        } : new TreeData(referencingElements, null);
        return input;
    }

    protected TreeData getInitialInputData() {
        return new TreeData(this._referencingElements, null);
    }

    protected TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }

    public void setContextMenuManagerFiller(AbstractContextMenuFiller filler_p) {
        this._contextMenuManagerFiller = filler_p;
    }

    protected class ImpactAnalysisLabelProvider
    extends CapellaElementLabelProvider
    implements IColorProvider {
        private int _foregroundColor;
        private TreeViewer _viewer;

        public ImpactAnalysisLabelProvider(TreeViewer viewer_p, int foregroundColorForReferencingElements_p) {
            this._foregroundColor = foregroundColorForReferencingElements_p;
            this._viewer = viewer_p;
        }

        public Color getBackground(Object element_p) {
            return null;
        }

        public Color getForeground(Object element_p) {
            Object input = this._viewer.getInput();
            if (input instanceof TreeData && ((TreeData)input).isValid(element_p)) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                return display.getSystemColor(this._foregroundColor);
            }
            return null;
        }

        public String getText(Object object_p) {
            String text = super.getText(object_p);
            return text.replace("%20", " ");
        }
    }

    protected class ImpactAnalysisSorter
    extends ViewerSorter {
        public ImpactAnalysisSorter() {
        }

        public ImpactAnalysisSorter(Collator collator_p) {
            super(collator_p);
        }

        public int compare(Viewer viewer_p, Object object1_p, Object object2_p) {
            if (object1_p instanceof Resource && object2_p instanceof Resource) {
                Resource resource1 = (Resource)object1_p;
                Resource resource2 = (Resource)object2_p;
                if (CapellaResourceHelper.isCapellaResource((Resource)resource1) && CapellaResourceHelper.isCapellaResource((Resource)resource2)) {
                    int result = 0;
                    boolean fragment1 = CapellaResourceHelper.isCapellaFragment((URI)resource1.getURI());
                    boolean fragment2 = CapellaResourceHelper.isCapellaFragment((URI)resource2.getURI());
                    if (fragment1 && !fragment2) {
                        result = 1;
                    } else if (!fragment1 && fragment2) {
                        result = -1;
                    }
                    return result;
                }
            }
            return super.compare(viewer_p, object1_p, object2_p);
        }
    }
}

