/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.capella.core.sirius.ui.Messages;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class SaveSessionAction
extends BaseSelectionListenerAction {
    public SaveSessionAction() {
        super("Save");
        this.setActionDefinitionId("org.eclipse.ui.file.save");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/save.gif"));
    }

    public void run() {
        ArrayList<Session> sessions = new ArrayList<Session>();
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        for (Object object : structuredSelection) {
            Session session;
            if (object instanceof Session) {
                sessions.add((Session)object);
                continue;
            }
            if (!(object instanceof IFile) || (session = SessionHelper.getSession((IFile)object)) == null) continue;
            sessions.add(session);
        }
        final ArrayList<Session> saveableSessions = new ArrayList<Session>();
        ArrayList<Session> unsaveableSessions = new ArrayList<Session>();
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Session session : sessions) {
            if (SessionHelper.areSessionResourcesSaveable(session, files)) {
                saveableSessions.add(session);
                continue;
            }
            unsaveableSessions.add(session);
        }
        Shell activeShell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(activeShell);
        try {
            IRunnableWithProgress saveSessionOperation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    for (Session session : saveableSessions) {
                        session.save(monitor);
                    }
                }
            };
            monitor.run(false, false, saveSessionOperation);
            if (!unsaveableSessions.isEmpty()) {
                String msg = Messages.unableToSaveDialog_TopMsg;
                for (IFile file : files) {
                    msg = String.valueOf(msg) + file.toString() + '\n';
                }
                MessageDialog.openWarning((Shell)activeShell, (String)Messages.unableToSaveDialog_Title, (String)msg);
            }
        }
        catch (InvocationTargetException ite) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.getBundleId(ite.getCause()), ite.getCause().getMessage(), ite.getCause()), 4);
        }
        catch (InterruptedException ie) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.getBundleId(ie), ie.getMessage(), (Throwable)ie));
        }
    }

    private String getBundleId(Object obj) {
        Bundle bundle = FrameworkUtil.getBundle(obj.getClass());
        if (bundle != null) {
            return bundle.getSymbolicName();
        }
        return obj.getClass().getCanonicalName();
    }
}

